/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.core;

import java.awt.image.PixelGrabber;

import net.dzzd.access.*;
import net.dzzd.utils.Log;
import java.awt.Toolkit;
import java.net.*;
import java.awt.image.*;


/** 
 *  Class to manage Texture
 *
 *  @version 1.0
 *  @since 1.0
 *  @author Bruno Augier
 *
 *  Copyright Bruno Augier 2005 
 */


import java.awt.Image;



public final class URLTexture extends ImageTexture implements IURLTexture,Runnable,ImageObserver
{
	public static final long serialVersionUID = 0x00000001;
	
	String baseURL;				//Texture base URL	
	String sourceFile;			//Source file name
	
	private boolean reload; 	//True if texture need to be reloaded
	
	public URLTexture()
	{
		super();
		this.sourceFile=null;
		this.baseURL=null;
		this.reload=true;
	}

	public void build()
	{
		
		if(this.reload)
			this.load();
		else
			super.build();
		
	}
	
	
	public void  run() 
    {
		if(this.sourceFile==null) return;
		if(this.baseURL==null) return;

		Toolkit t =Toolkit.getDefaultToolkit();
		try
		{
			URL url=new URL(this.baseURL+this.sourceFile.replace(' ','+'));	
			this.image=t.getImage(url);	
		}
		catch(MalformedURLException  mue)
		{
			Log.log(mue);
			this.endLoading(true);
			return;
		}
		
		if(this.image == null)
		{
			this.endLoading(true);
			return;
		}
				
		if(t.prepareImage(this.image,-1,-1,this))
		{
			this.endLoading(false);
			return;
		}

    	int flag=0;
    	do
    	{
			try
		  	{
		  		//System.out.println("check " + sourceFile);
		  		Thread.sleep(100);
		  		Thread.yield();
		  	}
		  	catch(InterruptedException ie)
		  	{
		  		this.endLoading(false);
		  	}
    		
    		
    		flag=t.checkImage(this.image,-1,-1,this);  
    				
    	}
    	while( (flag & ( ImageObserver.ALLBITS |  ImageObserver.ABORT |  ImageObserver.ERROR)) ==0);
    	
    	if((flag & ImageObserver.ALLBITS) !=0)
	   		this.endLoading(false);
		else
			this.endLoading(true);		
	}

   void endLoading(boolean error)
	{
		if(!error)
		{
			//Log.log("Loading finished : ("+this.baseURL+this.sourceFile+")");
			this.setImage(this.image);
			this.setError(false);
			this.setFinished(true);	
			this.build();
			return;
		}
		this.setError(true);
		this.setFinished(true);	

		Log.log("Loading error ("+this.baseURL+this.sourceFile+")");
	}

   public boolean imageUpdate(Image img,int infoflags,int x,int y,int width,int height)
	{
		  	switch(infoflags)
		  	{
		  		case ImageObserver.WIDTH|ImageObserver.HEIGHT:
		  			this.setMaximumProgress(width*height);
		  		return true;
		  		
		  		case ImageObserver.SOMEBITS:
		  			this.setProgress(x+y*width);
		  			 //uncomment to simulate network latency
		  			 
		  			 /*
		  			try
				  	{
				  		Thread.sleep(1);
				  	}
				  	catch(InterruptedException ie)
				  	{
				  		return false;
				  	}*/
				return true;
				  	

		  		case ImageObserver.PROPERTIES:
		  		
		  		return true;
		  		
		  		
		  		case ImageObserver.FRAMEBITS:
		  			//Prevent animated gif to hang return false
		  		return false;
		  		
		  		case ImageObserver.ALLBITS:
		  			this.setProgress(this.getMaximumProgress());
		  		return false;
		  		  		
		  		case ImageObserver.ERROR:
		  		return false;
		  		
		  		case ImageObserver.ABORT:
		  		return false;  
		  	}
		return false;
	}
   

    /*
     *INTERFACE ITexture
     */
    public void setSourceFile(String sourceFile)
    {
    	this.reload=true;
    	this.sourceFile=sourceFile;
    	this.setName(sourceFile);
    }
    
    public String getSourceFile()
    {
    	return this.sourceFile;
    }    
    
    public void setBaseURL(String baseURL)
    {
    	this.reload=true;
    	this.baseURL=baseURL;
    }
    
    public String getBaseURL()
    {
    	return this.baseURL;
    }
     
  	public void load (String baseURL,String sourceFile)
	{
		this.setBaseURL(baseURL);
		this.setSourceFile(sourceFile);
		this.load();
	}
	  
  	public void load(String baseURL,String sourceFile,boolean useMipMap)
	{
		this.setBaseURL(baseURL);
		this.setSourceFile(sourceFile);
		this.load();
	}
  
	public void load()
	{
		//Log.log("loading :"+this.sourceFile);
		this.reset();
		this.setAction(IProgressListener.ACTION_FILE_DOWNLOAD);
		this.reload=false;	
	 	Thread tr=new Thread(this);
	 	tr.start();
	}
	        	        
        
}
