import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import java.io.*;



public class AppletViewerFrame extends Frame  implements AppletStub,AppletContext,WindowListener,ActionListener,ComponentListener
{
	
	public static final long serialVersionUID=0x0001;
	
    private Insets insets;
    private Applet applet;
    private String status;
    private int width;
    private int height;
    private String directory;
    
     

    /**
     * The constructor.
     */  
     public AppletViewerFrame(int width,int height) 
     {
     	this.directory="file:";
     	this.width=width;
     	this.height=height;
              
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu();
        MenuItem menuFileExit = new MenuItem();
        MenuItem menuFileLoad = new MenuItem();
        MenuItem menuFilePause = new MenuItem();
        MenuItem menuFileResume = new MenuItem();
        
        menuFile.setLabel("File");
        menuFileExit.setLabel("Exit");
        menuFileExit.setActionCommand("EXIT");
        menuFileLoad.setLabel("Load");
        menuFileLoad.setActionCommand("LOAD");
        menuFilePause.setLabel("Stop");
        menuFilePause.setActionCommand("PAUSE");
        menuFileResume.setLabel("Start");
        menuFileResume.setActionCommand("RESUME");
        
        
        menuFile.add(menuFileExit);
        menuFile.add(menuFileLoad);
        menuFile.add(menuFilePause);
        menuFile.add(menuFileResume);
        menuBar.add(menuFile);
                     
        // Add listener.
        this.addWindowListener(this);
        this.addComponentListener(this);
        menuFile.addActionListener(this);
        
        this.setLayout(null);
        this.setTitle("DzzD - AppletViewer");
        this.setMenuBar(menuBar);
        this.setSize(new Dimension(this.width, this.height));    
		this.insets=this.getInsets();
		this.setVisible(true);
		this.setSize(new Dimension(this.width+this.insets.left+this.insets.right,this.height+this.insets.top+this.insets.bottom)); 
    }
    
    
	public void actionPerformed(ActionEvent e) 
	{
		this.doAction(e.getActionCommand());	
	}
	
	public void doAction(String action)
	{
		
		if(action.equals("EXIT"))
		{
			this.close();
		}
		if(action.equals("LOAD"))
		{
			this.load();
		}		
		if(action.equals("PAUSE"))
		{
			this.stop();						
		}
		if(action.equals("RESUME"))
		{
			this.start();						
		}
		
	}
	
	public void load()
	{
		FileDialog fd=new FileDialog(this,"Choose Applet class file",FileDialog.LOAD);
		fd.setModal(true);
		fd.show();
		String fileName=fd.getFile();
		if(fileName!=null)
		{
			this.directory="file:"+fd.getDirectory();
			int idx=fileName.indexOf('.');
			String className=fileName.substring(0,idx);
			try
			{
				System.out.println("Loading Applet " + className);
				URL urls[]=new URL[1];
				urls[0]=new URL(this.directory+fileName);
				URLClassLoader ucl=new URLClassLoader(urls);
				this.open((Applet)ucl.getSystemClassLoader().loadClass(className).newInstance());
			}
			catch(ClassNotFoundException cnfe)
			{
				cnfe.printStackTrace(System.out);
			}
			catch(InstantiationException ie)
			{
				ie.printStackTrace(System.out);
			}
			catch(IllegalAccessException iae)
			{
				iae.printStackTrace(System.out);
			}
			catch(MalformedURLException mue)
			{
				mue.printStackTrace(System.out);
			}
			
			System.out.println(fd.getDirectory());
			System.out.println(fd.getFile());
		}
		
	}
	
	    
    public void open(Applet applet)
    {
    	if(this.applet!=null)
    		this.destroy();

    	System.out.println("Open Applet");    		
    		
    	this.applet=applet;
    	
    	if(this.applet==null)
    		return;
    		
    	this.applet.setStub(this);
    	this.add(this.applet);	
	    this.applet.setBounds(this.insets.left,this.insets.top,this.width,this.height);	    
	    this.init();
    }
    
    public void init()
    {
    	if(this.applet==null)
    		return;
    	System.out.println("Init Applet");
    	this.applet.init();		
    }       
    
    public void start()
    {
    	if(this.applet==null)
    		return;
    	System.out.println("Start Applet");
    	this.applet.start();		
    }     
    
    public void stop()
    {
    	if(this.applet==null)
    		return;
    	System.out.println("Stop Applet");
    	this.applet.stop();		
    }        
    
    public void destroy()
    {
    	if(this.applet==null)
    		return;
    	System.out.println("Destroy Applet");
    	this.applet.destroy();
    	this.remove(this.applet);
    	this.applet=null;		
    }        
    
    public void close()
    {
    	
    	System.out.println("Close Applet");
    	this.destroy();
    	this.setVisible(false);	
    	this.dispose();
    }
    
    
    /**
     * Shutdown procedure when run as an application.
     */
    public void windowClosed(WindowEvent e)  
    {
    	System.exit(0);        
    }
    
    public void windowClosing(WindowEvent e) 
    {
    	this.close();
    }    
    
	public void windowActivated(WindowEvent e)
	{
			
	}
	
	public void windowDeactivated(WindowEvent e)
	{
    		
	} 
	
	public void windowDeiconified(WindowEvent e)
	{
    	
	}
	 
	public void windowIconified(WindowEvent e)
	{
		
	} 
	
	public void windowOpened(WindowEvent e)
	{
				
	} 
 
	public void componentHidden(ComponentEvent e)
	{
	}
          
	public void componentMoved(ComponentEvent e) 
	{
	}
          
	public void componentResized(ComponentEvent e) 
	{
		this.insets=this.getInsets();
	}
          
	public void componentShown(ComponentEvent e) 
	{
	}

	/**
	 * Applet Stub Interface
	 */
	public void appletResize(int width, int height) 
	{
	}
	
	public AppletContext getAppletContext() 
	{
		return this;
	}
	
	public URL getCodeBase() 
	{
		URL url=null;
		try
		{
			url=new URL("file:");
		}
		catch(MalformedURLException mue)
		{
			mue.printStackTrace(System.out);
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace(System.out);
		}
	
		return url;
	}
	
	public URL getDocumentBase() 
	{
		return getCodeBase();
	}
	
	public String getParameter(String name) 
	{
		return null;
	}
	
	public boolean isActive() 
	{
		return true;
	} 
	
	
	/**
	 * Applet Context Interface
	 */
	public Applet getApplet(String name) 
	{
		return null;
	}
	
	public Enumeration getApplets() 
	{
		return null;
	}
	
	public AudioClip getAudioClip(URL url) 
	{
		return Applet.newAudioClip(url) ;
	}
	
	public Image getImage(URL url) 
	{
		return Toolkit.getDefaultToolkit().createImage(url);
	}
	
	public InputStream getStream(String key) 
	{
		return null;
	}
	
	public Iterator getStreamKeys() 
	{
		return null;
	}
	
	public void setStream(String key, InputStream stream) 
	{
	}
	
	public void showDocument(URL url) 
	{
		try
		{
			Runtime.getRuntime().exec(url.toString());
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace(System.out);
		}
	}
	
	public void showDocument(URL url, String target) 
	{
		try
		{		
			Runtime.getRuntime().exec(url.toString());
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace(System.out);
		}
		
	}
	
	public void showStatus(String status) 
	{
		this.status=status;
	}	          
    
}
