/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.ICamera3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene;
import net.dzzd.access.IScene3D;
import net.dzzd.access.ITexture;
import net.dzzd.core.DirectInput;
import net.dzzd.core.Drawer;
import net.dzzd.core.Face3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render3D;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

public final class Render3DSW
extends Render3D {
    private int renderPixelWidth;
    private int renderPixelHeight;
    private double renderPixelWidthDiv2;
    private double renderPixelHeightDiv2;
    private int[] zBuffer;
    private short[] zBufferO;
    private int[] zBufferP;
    private int[] zBufferF;
    private int nbRenderedFace;
    private int nbRenderedMesh;
    private int[] vLinesBufferMin;
    private double[] vLinesBufferMinX;
    private double[] vLinesBufferMinIncX;
    private double[] vLinesBufferMinIz;
    private double[] vLinesBufferMinIncIz;
    private int[] vLinesBufferMax;
    private double[] vLinesBufferMaxX;
    private double[] vLinesBufferMaxIncX;
    private double[] vLinesBufferMaxIz;
    private double[] vLinesBufferMaxIncIz;
    private int hLinesBufferMin;
    private int hLinesBufferMax;
    private int zBufferMode;
    private boolean zBufferOcclusionTest;
    private double noFaceZ;
    private double noFaceIZ;
    private double noFaceX1;
    private int noFaceY1;
    private double noFaceX2;
    private int noFaceY2;
    static final int ZB_WRITE = 1;
    static final int ZB_ALPHA = 2;
    static final int ZB_TEST = 4;
    Drawer drawer;
    int lastRenderBackgroundOffset;
    int firstRenderBackgroundOffset;
    Face3D firstAlphaFace;
    Face3D lastAlphaFace;
    private CompiledMesh firstMeshToRender;
    private CompiledMesh[] compiledMeshes;
    private CompiledMaterial[] compiledMaterials;
    double iZTest;
    int r = 0;
    int r2 = 0;

    public Render3DSW() {
        this.directInput = new DirectInput(this.canvas);
        this.drawer = new Drawer();
        this.initCompiledBuffers();
    }

    private final void initCompiledBuffers() {
        this.compiledMeshes = new CompiledMesh[65536];
        this.compiledMaterials = new CompiledMaterial[1024];
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        this.resetBuffers();
    }

    public final void clearScene(IScene iScene) {
        super.clearScene(iScene);
        this.initCompiledBuffers();
    }

    protected final void disposeMesh3D(IMesh3D iMesh3D) {
        int n = iMesh3D.getId();
        CompiledMesh compiledMesh = this.compiledMeshes[n + 1];
        do {
            this.compiledMeshes[n++] = compiledMesh;
        } while ((compiledMesh = this.compiledMeshes[n + 1]) != null);
    }

    protected final void disposeCamera3D(ICamera3D iCamera3D) {
    }

    protected final void disposeLight3D(ILight3D iLight3D) {
    }

    protected final void disposeTexture(ITexture iTexture) {
    }

    protected final void disposeMaterial(IMaterial iMaterial) {
        int n = iMaterial.getId();
        CompiledMaterial compiledMaterial = this.compiledMaterials[n + 1];
        do {
            this.compiledMaterials[n++] = compiledMaterial;
        } while ((compiledMaterial = this.compiledMaterials[n + 1]) != null);
    }

    protected final void compileMesh3D(IMesh3D iMesh3D) {
        super.compileMesh3D(iMesh3D);
        this.compiledMeshes[iMesh3D.getId()] = new CompiledMesh((Mesh3D)iMesh3D);
    }

    protected final void compileMaterial(IMaterial iMaterial) {
        CompiledMaterial compiledMaterial;
        super.compileMaterial(iMaterial);
        this.compiledMaterials[iMaterial.getId()] = compiledMaterial = new CompiledMaterial((Material)iMaterial);
    }

    public final void setSize(int n, int n2, int n3) {
        super.setSize(n, n2, n3);
        this.renderPixelWidth = this.viewPixelWidth;
        this.renderPixelHeight = this.viewPixelHeight;
        if ((this.antialias & 2) != 0) {
            this.renderPixelWidth = this.viewPixelWidth << 1;
        }
        if ((this.antialias & 4) != 0) {
            this.renderPixelHeight = this.viewPixelHeight << 1;
        }
        this.minXValue = 0;
        this.maxXValue = this.renderPixelWidth;
        this.minYValue = 0;
        this.maxYValue = this.renderPixelHeight;
        this.renderPixelWidthDiv2 = this.renderPixelWidth >> 1;
        this.renderPixelHeightDiv2 = this.renderPixelHeight >> 1;
        this.initBuffers();
        this.drawer.setBuffers(this, this.zBuffer, this.zBufferF);
    }

    private final void renderFrameCoherence(IScene3D iScene3D) {
        this.zBufferOcclusionTest = false;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        while (compiledMesh != null) {
            Mesh3D mesh3D = compiledMesh.mesh;
            if (mesh3D.isVisible()) {
                if ((mesh3D.renderMode & 1) != 0) {
                    this.prepareMesh3DLocalLight3DBuffer(iScene3D, mesh3D);
                }
                if (mesh3D.getMesh3DViewGenerator() == null) {
                    this.setCurrentMesh3D(mesh3D);
                    CompiledFace compiledFace = compiledMesh.firstFaceToRender;
                    while (compiledFace != null) {
                        this.setFaces3DToZBuffer(mesh3D.getFaces3D(), compiledFace.face.id);
                        compiledFace.lastZbufferImage = this.numImage;
                        compiledFace = compiledFace.nextFaceToRender;
                    }
                }
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferOcclusionTest = true;
    }

    protected final void startFrame(IScene3D iScene3D) {
        this.drawer.setRender3DSW(this);
        this.resetBuffers();
        this.zBufferMode = 1;
        this.firstAlphaFace = null;
        this.lastAlphaFace = null;
        this.renderFrameCoherence(iScene3D);
    }

    protected final void renderFrame(IScene3D iScene3D) {
        super.renderFrame(iScene3D);
    }

    protected final void endFrame(IScene3D iScene3D) {
        if (!this.isPixelUpdateEnabled) {
            return;
        }
        this.prepareFaceBuffer(iScene3D);
        if (iScene3D.isBackgroundEnabled()) {
            this.renderBackground(iScene3D);
        }
        this.drawMesh3D(iScene3D);
        this.drawer.antialiasPixels();
        if (this.isScreenUpdateEnabled) {
            this.drawer.drawPixelsOnCanvas(this.canvas);
        }
    }

    private final void initBuffers() {
        this.zBuffer = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferO = new short[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferP = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferF = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.vLinesBufferMin = new int[this.renderPixelHeight];
        this.vLinesBufferMinX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIz = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncIz = new double[this.renderPixelHeight];
        this.vLinesBufferMax = new int[this.renderPixelHeight];
        this.vLinesBufferMaxX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIz = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncIz = new double[this.renderPixelHeight];
    }

    private final void resetBuffers() {
        int n = 0;
        for (int i = 0; i < this.renderPixelHeight; ++i) {
            this.zBuffer[n] = this.renderPixelWidth;
            this.zBufferO[n] = -1;
            this.zBufferP[n] = -1;
            n += this.renderPixelWidth;
        }
    }

    public final void setAntialiasLevel(int n) {
        if (n == this.antialias) {
            return;
        }
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        super.setAntialiasLevel(n);
    }

    protected final void renderBackground(IScene3D iScene3D) {
        if (this.firstRenderBackgroundOffset == -1) {
            return;
        }
        this.drawer.drawBackground(this.firstRenderBackgroundOffset, this.lastRenderBackgroundOffset, iScene3D.getBackgroundColor());
    }

    protected final void setMesh3DToZBuffer(IMesh3D iMesh3D) {
        double d;
        double d2;
        double d3;
        IPoint3D iPoint3D;
        double d4;
        CompiledMesh compiledMesh = this.compiledMeshes[iMesh3D.getId()];
        if (this.zBufferOcclusionTest && this.numImage - compiledMesh.lastRenderImage > 1 && this.isSphereVisibleInZBuffer(d4 = (iPoint3D = iMesh3D.getCenter()).getX(), d3 = iPoint3D.getY(), d2 = iPoint3D.getZ(), d = iMesh3D.getSphereBox()) != 1) {
            return;
        }
        this.setFaces3DToZBuffer(iMesh3D.getFaces3D(), -1);
    }

    protected void _setMesh3DOctreeToZBuffer(Mesh3D mesh3D, Mesh3DOctree mesh3DOctree) {
        double d;
        double d2;
        double d3;
        double d4;
        CompiledMesh compiledMesh = this.compiledMeshes[mesh3D.getId()];
        if (this.zBufferOcclusionTest && this.numImage - compiledMesh.lastRenderImage > 1) {
            double d5;
            double d6;
            double d7;
            IPoint3D iPoint3D = mesh3D.getCenter();
            double d8 = iPoint3D.getX();
            if (this.isSphereVisible(d8, d7 = iPoint3D.getY(), d6 = iPoint3D.getZ(), d5 = mesh3D.getSphereBox()) != 1) {
                return;
            }
            if (this.isSphereVisibleInZBuffer(d8, d7, d6, d5) != 1) {
                return;
            }
        }
        if (this.isSphereVisible(d4 = mesh3DOctree.center.x, d3 = mesh3DOctree.center.y, d2 = mesh3DOctree.center.z, d = mesh3DOctree.visibilitySphereBoxRadius) == 1) {
            if (mesh3DOctree.getNbFace3D() > 0) {
                this.setMesh3DOctreeToZBuffer(mesh3DOctree);
            }
            for (int i = 0; i < mesh3DOctree.getNbChildren(false); ++i) {
                if (mesh3DOctree.childrens[i] == null) continue;
                this._setMesh3DOctreeToZBuffer(mesh3D, mesh3DOctree.childrens[i]);
            }
        }
    }

    protected final void setMesh3DOctreeToZBuffer(IMesh3DOctree iMesh3DOctree) {
        this.setFaces3DToZBuffer(iMesh3DOctree.getFaces3D(), -1);
    }

    protected final int isSphereVisible(double d, double d2, double d3, double d4) {
        int n = super.isSphereVisible(d, d2, d3, d4);
        return n;
    }

    private final int isSphereVisibleInZBuffer(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        int n;
        int n2;
        int n3;
        double d7 = this.ox + this.axx * d + this.ayx * d2 + this.azx * d3;
        double d8 = this.oy + this.axy * d + this.ayy * d2 + this.azy * d3;
        double d9 = this.oz + this.axz * d + this.ayz * d2 + this.azz * d3;
        if (d7 * d7 + d8 * d8 + d9 * d9 <= d4 * d4) {
            return 1;
        }
        double d10 = d9 - d4;
        if (d10 <= this.zMin) {
            return 1;
        }
        double d11 = d9 + d4;
        double d12 = 1.0 / d9;
        double d13 = 1.0 / d10;
        double d14 = 1.0 / d11;
        int n4 = (int)((d7 - d4) * this.screenZoomXFocus * d13 + this.renderPixelWidthDiv2);
        int n5 = (int)((d7 + d4) * this.screenZoomXFocus * d13 + this.renderPixelWidthDiv2);
        int n6 = (int)((d7 - d4) * this.screenZoomXFocus * d14 + this.renderPixelWidthDiv2);
        int n7 = (int)((d7 + d4) * this.screenZoomXFocus * d14 + this.renderPixelWidthDiv2);
        int n8 = (int)((d8 - d4) * this.screenZoomXFocus * d13 + this.renderPixelHeightDiv2);
        int n9 = (int)((d8 + d4) * this.screenZoomXFocus * d13 + this.renderPixelHeightDiv2);
        int n10 = (int)((d8 - d4) * this.screenZoomXFocus * d14 + this.renderPixelHeightDiv2);
        int n11 = (int)((d8 + d4) * this.screenZoomXFocus * d14 + this.renderPixelHeightDiv2);
        int n12 = n4;
        if (n5 < n12) {
            n12 = n5;
        }
        if (n6 < n12) {
            n12 = n6;
        }
        if (n7 < n12) {
            n12 = n7;
        }
        if (n5 > (n3 = n4)) {
            n3 = n5;
        }
        if (n6 > n3) {
            n3 = n6;
        }
        if (n7 > n3) {
            n3 = n7;
        }
        if (n9 < (n2 = n8)) {
            n2 = n9;
        }
        if (n10 < n2) {
            n2 = n10;
        }
        if (n11 < n2) {
            n2 = n11;
        }
        if (n9 > (n = n8)) {
            n = n9;
        }
        if (n10 > n) {
            n = n10;
        }
        if (n11 > n) {
            n = n11;
        }
        if (this.minXValue > n3) {
            return 0;
        }
        if (this.maxXValue < n12) {
            return 0;
        }
        if (this.minYValue > n) {
            return 0;
        }
        if (this.maxYValue < n2) {
            return 0;
        }
        if (this.minXValue > n12) {
            n12 = this.minXValue;
        }
        if (this.maxXValue < n3) {
            n3 = this.maxXValue;
        }
        if (this.minYValue > n2) {
            n2 = this.minYValue;
        }
        if (this.maxYValue < n) {
            n = this.maxYValue;
        }
        if ((d6 = (double)(n3 - n12)) * (d5 = (double)(n - n2)) > this.renderPixelWidthDiv2 * this.renderPixelHeightDiv2) {
            return 1;
        }
        return this.isSquareVisibleInZBuffer(n12, n2, n3, n, d13);
    }

    private final int isSquareVisibleInZBuffer(int n, int n2, int n3, int n4, double d) {
        this.hLinesBufferMin = n2;
        this.hLinesBufferMax = n4;
        this.vLinesBufferMin[n2] = n4;
        this.vLinesBufferMinX[n2] = n;
        this.vLinesBufferMinIncX[n2] = 0.0;
        this.vLinesBufferMinIz[n2] = d;
        this.vLinesBufferMinIncIz[n2] = 0.0;
        this.vLinesBufferMax[n2] = n4;
        this.vLinesBufferMaxX[n2] = n3;
        this.vLinesBufferMaxIncX[n2] = 0.0;
        this.vLinesBufferMaxIz[n2] = d;
        this.vLinesBufferMaxIncIz[n2] = 0.0;
        this.iZTest = d;
        int n5 = this.zBufferMode;
        this.zBufferMode = 4;
        int n6 = this.pasteHLine(null);
        this.zBufferMode = n5;
        return n6;
    }

    private final CompiledFace getCompiledFace(int n, int n2) {
        return this.compiledMeshes[n].compiledFaces[n2];
    }

    protected final int setFaces3DToZBuffer(IFace3D[] iFace3DArray, int n) {
        int n2 = 0;
        Face3D[] face3DArray = (Face3D[])iFace3DArray;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = face3DArray.length;
        int n4 = 0;
        if (n >= 0) {
            n4 = n;
            n3 = n + 1;
        }
        while (n4 < n3) {
            block46: {
                double d5;
                double d6;
                CompiledFace compiledFace;
                Face3D face3D;
                block48: {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    double d16;
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    double d21;
                    double d22;
                    double d23;
                    double d24;
                    block47: {
                        double d25;
                        block45: {
                            face3D = face3DArray[n4];
                            if ((this.zBufferMode & 2) != 0 || face3D.material == null || face3D.material.alphaLevel == 0) break block45;
                            face3D.nextAlphaFace = null;
                            if (this.firstAlphaFace == null) {
                                this.firstAlphaFace = face3D;
                                this.lastAlphaFace = face3D;
                            } else {
                                face3D.nextAlphaFace = this.firstAlphaFace;
                                this.firstAlphaFace = face3D;
                            }
                            break block46;
                        }
                        int n5 = face3D.object.id;
                        compiledFace = this.getCompiledFace(n5, face3D.id);
                        CompiledMesh compiledMesh = this.compiledMeshes[n5];
                        if (compiledFace.lastZbufferImage == this.numImage) break block46;
                        compiledFace.lastZbufferImage = this.numImage;
                        if (compiledFace.lastRenderImage == this.numImage || (d25 = (double)face3D.pa * (face3D.center.x - this.px) + (double)face3D.pb * (face3D.center.y - this.py) + (double)face3D.pc * (face3D.center.z - this.pz)) > 0.0) break block46;
                        double d26 = this.maxYValue;
                        double d27 = this.minYValue;
                        double d28 = this.maxXValue;
                        double d29 = this.minXValue;
                        d6 = this.zMax;
                        d5 = this.zMin;
                        this.hLinesBufferMin = 0x7FFFFFFE;
                        this.hLinesBufferMax = -2147483646;
                        Point3D point3D = face3D.center;
                        double d30 = point3D.x;
                        double d31 = point3D.y;
                        double d32 = point3D.z;
                        double d33 = this.ox + this.axx * d30 + this.ayx * d31 + this.azx * d32;
                        double d34 = this.oy + this.axy * d30 + this.ayy * d31 + this.azy * d32;
                        double d35 = this.oz + this.axz * d30 + this.ayz * d31 + this.azz * d32;
                        double d36 = face3D.sphereBox;
                        double d37 = d35 - d36;
                        double d38 = d35 + d36;
                        if (d38 <= this.zMin || d37 >= this.zMax || this.RA * d33 + this.RB * d34 + this.RC * d35 >= d36 || this.LA * d33 + this.LB * d34 + this.LC * d35 >= d36 || this.UA * d33 + this.UB * d34 + this.UC * d35 >= d36 || this.DA * d33 + this.DB * d34 + this.DC * d35 >= d36) break block46;
                        int[] nArray = compiledMesh.cameraPositionEvaluated;
                        double[] dArray = compiledMesh.xs;
                        double[] dArray2 = compiledMesh.ys;
                        double[] dArray3 = compiledMesh.iz;
                        double[] dArray4 = compiledMesh.xp;
                        double[] dArray5 = compiledMesh.yp;
                        double[] dArray6 = compiledMesh.zp;
                        Vertex3D vertex3D = face3D.p0;
                        int n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d30 = vertex3D.x;
                            d31 = vertex3D.y;
                            d32 = vertex3D.z;
                            d24 = this.ox + this.axx * d30 + this.ayx * d31 + this.azx * d32;
                            d23 = this.oy + this.axy * d30 + this.ayy * d31 + this.azy * d32;
                            d22 = this.oz + this.axz * d30 + this.ayz * d31 + this.azz * d32;
                            d21 = 1.0 / d22;
                            d20 = d24 * this.screenZoomXFocus * d21 + this.renderPixelWidthDiv2;
                            d19 = d23 * this.screenZoomYFocus * d21 + this.renderPixelHeightDiv2;
                            if (d22 < 0.0) {
                                d20 = -d20;
                                d19 = -d19;
                            }
                            dArray[n6] = d20;
                            dArray2[n6] = d19;
                            dArray3[n6] = d21;
                            dArray6[n6] = d22;
                            dArray4[n6] = d24;
                            dArray5[n6] = d23;
                            dArray6[n6] = d22;
                        } else {
                            d20 = dArray[n6];
                            d19 = dArray2[n6];
                            d21 = dArray3[n6];
                            d24 = dArray4[n6];
                            d23 = dArray5[n6];
                            d22 = dArray6[n6];
                        }
                        vertex3D = face3D.p1;
                        n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d30 = vertex3D.x;
                            d31 = vertex3D.y;
                            d32 = vertex3D.z;
                            d18 = this.ox + this.axx * d30 + this.ayx * d31 + this.azx * d32;
                            d17 = this.oy + this.axy * d30 + this.ayy * d31 + this.azy * d32;
                            d16 = this.oz + this.axz * d30 + this.ayz * d31 + this.azz * d32;
                            d15 = 1.0 / d16;
                            d14 = d18 * this.screenZoomXFocus * d15 + this.renderPixelWidthDiv2;
                            d13 = d17 * this.screenZoomYFocus * d15 + this.renderPixelHeightDiv2;
                            if (d16 < 0.0) {
                                d14 = -d14;
                                d13 = -d13;
                            }
                            dArray[n6] = d14;
                            dArray2[n6] = d13;
                            dArray3[n6] = d15;
                            dArray4[n6] = d18;
                            dArray5[n6] = d17;
                            dArray6[n6] = d16;
                        } else {
                            d14 = dArray[n6];
                            d13 = dArray2[n6];
                            d15 = dArray3[n6];
                            d18 = dArray4[n6];
                            d17 = dArray5[n6];
                            d16 = dArray6[n6];
                        }
                        vertex3D = face3D.p2;
                        n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d30 = vertex3D.x;
                            d31 = vertex3D.y;
                            d32 = vertex3D.z;
                            d12 = this.ox + this.axx * d30 + this.ayx * d31 + this.azx * d32;
                            d11 = this.oy + this.axy * d30 + this.ayy * d31 + this.azy * d32;
                            d10 = this.oz + this.axz * d30 + this.ayz * d31 + this.azz * d32;
                            d9 = 1.0 / d10;
                            d8 = d12 * this.screenZoomXFocus * d9 + this.renderPixelWidthDiv2;
                            d7 = d11 * this.screenZoomYFocus * d9 + this.renderPixelHeightDiv2;
                            if (d10 < 0.0) {
                                d8 = -d8;
                                d7 = -d7;
                            }
                            dArray[n6] = d8;
                            dArray2[n6] = d7;
                            dArray3[n6] = d9;
                            dArray4[n6] = d12;
                            dArray5[n6] = d11;
                            dArray6[n6] = d10;
                        } else {
                            d8 = dArray[n6];
                            d7 = dArray2[n6];
                            d9 = dArray3[n6];
                            d12 = dArray4[n6];
                            d11 = dArray5[n6];
                            d10 = dArray6[n6];
                        }
                        if (d22 > d5) {
                            d5 = d22;
                        }
                        if (d22 < d6) {
                            d6 = d22;
                        }
                        if (d16 > d5) {
                            d5 = d16;
                        }
                        if (d16 < d6) {
                            d6 = d16;
                        }
                        if (d10 > d5) {
                            d5 = d10;
                        }
                        if (d10 < d6) {
                            d6 = d10;
                        }
                        if (d5 <= this.zMin || d6 >= this.zMax) break block46;
                        if (d19 < d26) {
                            d26 = d19;
                        }
                        if (d19 > d27) {
                            d27 = d19;
                        }
                        if (d13 < d26) {
                            d26 = d13;
                        }
                        if (d13 > d27) {
                            d27 = d13;
                        }
                        if (d7 < d26) {
                            d26 = d7;
                        }
                        if (d7 > d27) {
                            d27 = d7;
                        }
                        if (d27 <= (double)this.minYValue || d26 >= (double)this.maxYValue || d27 <= d26 + 5.0E-4) break block46;
                        if (d20 < d28) {
                            d28 = d20;
                        }
                        if (d20 > d29) {
                            d29 = d20;
                        }
                        if (d14 < d28) {
                            d28 = d14;
                        }
                        if (d14 > d29) {
                            d29 = d14;
                        }
                        if (d8 < d28) {
                            d28 = d8;
                        }
                        if (d8 > d29) {
                            d29 = d8;
                        }
                        if (d29 <= (double)this.minXValue || d28 >= (double)this.maxXValue || d29 <= d28 + 5.0E-4) break block46;
                        if (!(d6 >= this.zMin)) break block47;
                        this.setHLigne(d20, d19, d21, d14, d13, d15);
                        this.setHLigne(d14, d13, d15, d8, d7, d9);
                        this.setHLigne(d8, d7, d9, d20, d19, d21);
                        break block48;
                    }
                    boolean bl = false;
                    Vertex3D vertex3D = face3D.p0;
                    Vertex3D vertex3D2 = face3D.p1;
                    double d39 = d20;
                    double d40 = d19;
                    double d41 = d21;
                    double d42 = d24;
                    double d43 = d23;
                    double d44 = d22;
                    double d45 = d14;
                    double d46 = d13;
                    double d47 = d15;
                    double d48 = d18;
                    double d49 = d17;
                    double d50 = d16;
                    for (int i = 0; i < 3; ++i) {
                        double d51;
                        double d52;
                        double d53;
                        double d54;
                        double d55;
                        double d56;
                        if (d44 >= this.zMin && d50 >= this.zMin) {
                            this.setHLigne(d39, d40, d41, d45, d46, d47);
                        } else if (d44 < this.zMin && d50 >= this.zMin) {
                            d56 = d48 - d42;
                            d55 = d49 - d43;
                            d54 = d50 - d44;
                            d53 = 1.0 / d54;
                            d52 = (this.zMin - d44) * d56 * d53 + d42;
                            d51 = (this.zMin - d44) * d55 * d53 + d43;
                            d = d52 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d2 = d51 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(d, d2, this.iZMin, d45, d46, d47);
                            bl = true;
                        } else if (d50 < this.zMin && d44 >= this.zMin) {
                            d56 = d42 - d48;
                            d55 = d43 - d49;
                            d54 = d44 - d50;
                            d53 = 1.0 / d54;
                            d52 = (this.zMin - d50) * d56 * d53 + d48;
                            d51 = (this.zMin - d50) * d55 * d53 + d49;
                            d3 = d52 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d4 = d51 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(d39, d40, d41, d3, d4, this.iZMin);
                            bl = true;
                        }
                        vertex3D = vertex3D2;
                        d39 = d45;
                        d40 = d46;
                        d41 = d47;
                        d42 = d48;
                        d43 = d49;
                        d44 = d50;
                        if (i == 0) {
                            vertex3D2 = face3D.p2;
                            d45 = d8;
                            d46 = d7;
                            d47 = d9;
                            d48 = d12;
                            d49 = d11;
                            d50 = d10;
                            continue;
                        }
                        vertex3D2 = face3D.p0;
                        d45 = d20;
                        d46 = d19;
                        d47 = d21;
                        d48 = d24;
                        d49 = d23;
                        d50 = d22;
                    }
                    if (!bl) break block46;
                    this.setHLigne(d3, d4, this.iZMin, d, d2, this.iZMin);
                }
                if (this.hLinesBufferMax > this.hLinesBufferMin) {
                    compiledFace.lastRenderOffset = -1;
                    compiledFace.firstRenderOffset = -1;
                    compiledFace.computeScreenSpace();
                    compiledFace.zMin = d6;
                    compiledFace.zMax = d5;
                    if (this.pasteHLine(compiledFace) != 0) {
                        n2 = 1;
                    }
                    if ((this.zBufferMode & 2) != 0 && compiledFace.firstRenderOffset != -1) {
                        this.drawer.setMesh3D(face3D.object);
                        if ((face3D.object.renderMode & 1) != 0) {
                            this.prepareMesh3DLocalLight3DBuffer(face3D.object.getScene3D(), face3D.object);
                        }
                        this.drawer.drawFace3D(this.compiledMeshes[face3D.object.id], this.compiledMeshes[face3D.object.id].compiledFaces[face3D.id], true);
                    }
                }
            }
            ++n4;
        }
        return n2;
    }

    private final void setHLigne(double d, double d2, double d3, double d4, double d5, double d6) {
        int n;
        int n2;
        boolean bl = true;
        if (d2 > d5) {
            bl = false;
            double d7 = d;
            double d8 = d2;
            double d9 = d3;
            d = d4;
            d2 = d5;
            d3 = d6;
            d4 = d7;
            d5 = d8;
            d6 = d9;
        }
        if (d2 > (double)this.maxYValue) {
            return;
        }
        if (d5 < (double)this.minYValue) {
            return;
        }
        if (d5 - d2 == 0.0) {
            return;
        }
        double d10 = 1.0 / (d5 - d2);
        double d11 = (d4 - d) * d10;
        double d12 = d - d11 * d2;
        double d13 = (d6 - d3) * d10;
        double d14 = d3 - d13 * d2;
        if (d2 < (double)this.minYValue) {
            d = d11 * (double)this.minYValue + d12;
            d3 = d13 * (double)this.minYValue + d14;
            d2 = this.minYValue;
        }
        if (d5 > (double)this.maxYValue) {
            d4 = d11 * (double)this.maxYValue + d12;
            d6 = d13 * (double)this.maxYValue + d14;
            d5 = this.maxYValue;
        }
        if ((n2 = (int)d2) == (n = (int)d5)) {
            return;
        }
        if (n > this.hLinesBufferMax) {
            this.hLinesBufferMax = n;
        }
        if (n2 < this.hLinesBufferMin) {
            this.hLinesBufferMin = n2;
        }
        if (bl) {
            this.vLinesBufferMin[n2] = n;
            this.vLinesBufferMinX[n2] = d;
            this.vLinesBufferMinIncX[n2] = d11;
            this.vLinesBufferMinIz[n2] = d3;
            this.vLinesBufferMinIncIz[n2] = d13;
        } else {
            this.vLinesBufferMax[n2] = n;
            this.vLinesBufferMaxX[n2] = d;
            this.vLinesBufferMaxIncX[n2] = d11;
            this.vLinesBufferMaxIz[n2] = d3;
            this.vLinesBufferMaxIncIz[n2] = d13;
        }
    }

    private double getFaceIzAt(int n, int n2, double d, double d2) {
        if (n == -1) {
            return this.iZMax;
        }
        if (n == -2) {
            return this.iZTest;
        }
        double d3 = d - this.renderPixelWidthDiv2;
        double d4 = d2 - this.renderPixelHeightDiv2;
        CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
        double d5 = compiledFace.iZA;
        double d6 = compiledFace.iZB;
        double d7 = compiledFace.iZC;
        double d8 = (d3 *= this.iZoomX) * d5 + (d4 *= this.iZoomY) * d6 + d7;
        return d8;
    }

    private double getZmax(int n, int n2) {
        if (n == -1) {
            return 1.0 / this.iZMax;
        }
        if (n == -2) {
            return 1.0 / this.iZTest;
        }
        CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
        return compiledFace.zMax;
    }

    private double getZmin(int n, int n2) {
        if (n == -1) {
            return 1.0 / this.iZMin;
        }
        if (n == -2) {
            return 1.0 / this.iZTest;
        }
        CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
        return compiledFace.zMin;
    }

    private double getFaceIzX(int n, int n2, int n3, int n4, double d) {
        double d2 = d - this.renderPixelHeightDiv2;
        d2 *= this.iZoomY;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.iZTest;
        if (n != -2) {
            CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
            d3 = compiledFace.iZA;
            d4 = compiledFace.iZB;
            d5 = compiledFace.iZC;
        }
        double d6 = d4 * d2 + d5;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = this.iZMax;
        if (n3 != -1) {
            CompiledFace compiledFace = this.compiledMeshes[n3].compiledFaces[n4];
            d7 = compiledFace.iZA;
            d8 = compiledFace.iZB;
            d9 = compiledFace.iZC;
        }
        double d10 = d8 * d2 + d9;
        double d11 = (d10 - d6) / (d3 - d7);
        return d11 / this.iZoomX + this.renderPixelWidthDiv2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int pasteHLine(CompiledFace compiledFace) {
        int n = 0;
        int n2 = -2;
        int n3 = -2;
        double d = this.getZmin(n2, n3);
        double d2 = this.getZmax(n2, n3);
        if (compiledFace != null) {
            n2 = this.cMesh3D.id;
            n3 = compiledFace.face.id;
            d = compiledFace.zMin;
            d2 = compiledFace.zMax;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.hLinesBufferMin * this.renderPixelWidth;
        int n7 = this.vLinesBufferMin[this.hLinesBufferMin];
        double d5 = this.vLinesBufferMinX[this.hLinesBufferMin];
        double d6 = this.vLinesBufferMinIncX[this.hLinesBufferMin];
        double d7 = this.vLinesBufferMinIz[this.hLinesBufferMin];
        double d8 = this.vLinesBufferMinIncIz[this.hLinesBufferMin];
        int n8 = this.vLinesBufferMax[this.hLinesBufferMin];
        double d9 = this.vLinesBufferMaxX[this.hLinesBufferMin];
        double d10 = this.vLinesBufferMaxIncX[this.hLinesBufferMin];
        double d11 = this.vLinesBufferMaxIz[this.hLinesBufferMin];
        double d12 = this.vLinesBufferMaxIncIz[this.hLinesBufferMin];
        double d13 = d5;
        double d14 = d9;
        double d15 = d7;
        double d16 = d11;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.hLinesBufferMin;
        while (true) {
            block43: {
                if (n11 >= this.hLinesBufferMax) {
                    return n;
                }
                if (n11 != this.hLinesBufferMin) {
                    n6 += this.renderPixelWidth;
                    d13 = d5 + d6 * (double)n9;
                    d14 = d9 + d10 * (double)n10;
                    d15 = d7 + d8 * (double)n9;
                    d16 = d11 + d12 * (double)n10;
                    if (n11 == n7) {
                        n7 = this.vLinesBufferMin[n11];
                        d5 = this.vLinesBufferMinX[n11];
                        d6 = this.vLinesBufferMinIncX[n11];
                        d7 = this.vLinesBufferMinIz[n11];
                        d8 = this.vLinesBufferMinIncIz[n11];
                        n9 = 0;
                        d13 = d5;
                        d15 = d7;
                    }
                    if (n11 == n8) {
                        n8 = this.vLinesBufferMax[n11];
                        d9 = this.vLinesBufferMaxX[n11];
                        d10 = this.vLinesBufferMaxIncX[n11];
                        d11 = this.vLinesBufferMaxIz[n11];
                        d12 = this.vLinesBufferMaxIncIz[n11];
                        n10 = 0;
                        d14 = d9;
                        d16 = d11;
                    }
                }
                double d17 = d13;
                double d18 = d14;
                double d19 = 0.0;
                double d20 = 0.0;
                double d21 = d18 - d17;
                if (d17 >= (double)this.maxXValue) {
                    if (d6 >= 0.0) {
                        return 0;
                    }
                } else {
                    if (d17 < (double)this.minXValue) {
                        d19 = (double)this.minXValue - d17;
                        d17 = this.minXValue;
                    }
                    if (d18 <= (double)this.minXValue) {
                        if (d10 <= 0.0) {
                            return 0;
                        }
                    } else {
                        int n12;
                        int n13;
                        if (d18 > (double)this.maxXValue) {
                            d20 = d18 - (double)this.maxXValue;
                            d18 = this.maxXValue;
                        }
                        if ((n13 = (int)d18) > (n12 = (int)d17)) {
                            int n14;
                            boolean bl = false;
                            int n15 = 0;
                            int n16 = this.zBuffer[n6] & 0xFFFF;
                            while (n12 >= n16) {
                                n15 = n16;
                                n16 = this.zBuffer[n6 + n16] & 0xFFFF;
                            }
                            int n17 = n15;
                            while (n13 > (n14 = n17) && n14 < this.renderPixelWidth) {
                                double d22;
                                double d23;
                                double d24;
                                boolean bl2;
                                int n18 = n6 + n14;
                                n17 = this.zBuffer[n18] & 0xFFFF;
                                short s = this.zBufferO[n18];
                                int n19 = this.zBufferP[n18];
                                double d25 = this.getZmin(s, n19);
                                double d26 = this.getZmax(s, n19);
                                boolean bl3 = d2 <= d25;
                                boolean bl4 = bl2 = d > d26;
                                if (!bl) {
                                    if (bl2) {
                                        if (n13 > n17) continue;
                                        break block43;
                                    }
                                    d24 = Math.min((double)n17, d18);
                                    d23 = Math.max((double)n14, d17);
                                    if (bl3 || this.getFaceIzAt(n2, n3, d23 + 0.5, n11) >= this.getFaceIzAt(s, n19, d23 + 0.5, n11)) {
                                        d3 = d23;
                                        bl = true;
                                    } else if (this.getFaceIzAt(n2, n3, d24, n11) > this.getFaceIzAt(s, n19, d24, n11) && (d22 = this.getFaceIzX(n2, n3, s, n19, n11)) >= d23 && d22 < d24) {
                                        d3 = d22;
                                        bl = true;
                                    }
                                    if (!bl) continue;
                                    if ((this.zBufferMode & 4) != 0) {
                                        return 1;
                                    }
                                    n4 = (int)d3;
                                    n5 = n14;
                                }
                                d24 = Math.min((double)n17, d18);
                                d23 = Math.max((double)n14, d3);
                                if (bl3) {
                                    if (n13 > n17) continue;
                                    d4 = d18;
                                    bl = false;
                                } else if (bl2 || this.getFaceIzAt(n2, n3, d23 + 0.5, n11) < this.getFaceIzAt(s, n19, d23 + 0.5, n11)) {
                                    d4 = d23;
                                    bl = false;
                                } else if (this.getFaceIzAt(n2, n3, d24, n11) < this.getFaceIzAt(s, n19, d24, n11)) {
                                    d22 = this.getFaceIzX(n2, n3, s, n19, n11);
                                    if (d22 >= d23) {
                                        if (d22 <= d24) {
                                            d4 = d22;
                                            bl = false;
                                        } else {
                                            d4 = d24;
                                            bl = false;
                                        }
                                    } else {
                                        d4 = d23;
                                        bl = false;
                                    }
                                }
                                if (bl && n13 <= n17) {
                                    d4 = d18;
                                    bl = false;
                                }
                                if (bl || d3 != d4) {
                                    int n20;
                                    int n21;
                                    int n22;
                                    if (bl) continue;
                                    int n23 = (int)(d3 * 65536.0) >> 8 & 0xFF;
                                    int n24 = (int)(d4 * 65536.0) >> 8 & 0xFF;
                                    int n25 = (int)d4;
                                    if (n25 == n4) {
                                        bl = false;
                                        continue;
                                    }
                                    if ((this.zBufferMode & 1) != 0 || (this.zBufferMode & 2) != 0) {
                                        n = 1;
                                        if (n4 != n5) {
                                            n22 = this.zBuffer[n6 + n5] >> 16 & 0xFF;
                                            this.zBuffer[n6 + n5] = n4 | n22 << 16;
                                        }
                                        n22 = n6 + n14;
                                        n21 = this.zBufferO[n22];
                                        n20 = this.zBufferP[n22];
                                        int n26 = n6 + n4;
                                        this.zBufferO[n26] = (short)this.cMesh3D.id;
                                        this.zBufferP[n26] = compiledFace.face.id;
                                        this.zBuffer[n26] = n25 | n23 << 16;
                                        if (n25 != n17) {
                                            int n27 = n6 + n25;
                                            this.zBuffer[n27] = n17 | n24 << 16;
                                            this.zBufferO[n27] = (short)n21;
                                            this.zBufferP[n27] = n20;
                                        }
                                    }
                                    if ((this.zBufferMode & 2) != 0) {
                                        n = 1;
                                        if (n25 != n4) {
                                            if (compiledFace.lastRenderImage != this.numImage) {
                                                compiledFace.lastRenderImage = this.numImage;
                                                compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n4 | n11 << 16 & 0xFFFF0000;
                                            } else {
                                                n22 = compiledFace.lastRenderOffset;
                                                n21 = n22 >> 16 & 0xFFFF;
                                                n20 = (n22 &= 0xFFFF) + n21 * this.renderPixelWidth;
                                                this.zBufferF[n20] = n4 | n11 << 16 & 0xFFFF0000;
                                                compiledFace.lastRenderOffset = n4 | n11 << 16 & 0xFFFF0000;
                                            }
                                        }
                                    }
                                    n17 = n25;
                                    continue;
                                }
                                break block43;
                            }
                            if (bl) {
                                Log.log("erreur");
                            }
                        }
                    }
                }
            }
            ++n11;
            ++n9;
            ++n10;
        }
    }

    private final void prepareFaceBuffer(IScene3D iScene3D) {
        int n;
        int n2;
        int n3;
        CompiledMesh compiledMesh = null;
        CompiledFace compiledFace = null;
        this.firstRenderBackgroundOffset = -1;
        this.firstMeshToRender = null;
        this.nbRenderedFace = 0;
        this.nbRenderedMesh = 0;
        short s = -1;
        int n4 = -1;
        for (n3 = 0; n3 < this.renderPixelHeight; ++n3) {
            n2 = 0;
            n = n3 * this.renderPixelWidth;
            while (n2 != this.renderPixelWidth) {
                int n5;
                int n6;
                int n7;
                int n8 = n + n2;
                int n9 = this.zBuffer[n8] & 0xFFFF;
                short s2 = this.zBufferO[n8];
                if (s2 != -1) {
                    if (s2 != s) {
                        compiledMesh = this.compiledMeshes[s2];
                        s = s2;
                        n4 = -1;
                    }
                    if (compiledMesh.lastRenderImage != this.numImage) {
                        compiledMesh.lastRenderImage = this.numImage;
                        compiledMesh.nbRenderFace = 0;
                        compiledMesh.firstFaceToRender = null;
                        compiledMesh.nextMeshToRender = this.firstMeshToRender;
                        this.firstMeshToRender = compiledMesh;
                        ++this.nbRenderedMesh;
                    }
                    if ((n7 = this.zBufferP[n8]) != n4) {
                        compiledFace = compiledMesh.compiledFaces[n7];
                        n4 = n7;
                    }
                    if (compiledFace.lastRenderImage != this.numImage) {
                        compiledFace.lastRenderImage = this.numImage;
                        compiledFace.nextFaceToRender = compiledMesh.firstFaceToRender;
                        compiledMesh.firstFaceToRender = compiledFace;
                        ++compiledMesh.nbRenderFace;
                        compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                        ++this.nbRenderedFace;
                    } else {
                        n6 = compiledFace.lastRenderOffset;
                        n5 = n6 >> 16 & 0xFFFF;
                        int n10 = (n6 &= 0xFFFF) + n5 * this.renderPixelWidth;
                        this.zBufferF[n10] = n2 | n3 << 16 & 0xFFFF0000;
                        compiledFace.lastRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                    }
                } else if (this.firstRenderBackgroundOffset == -1) {
                    this.lastRenderBackgroundOffset = this.firstRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                } else {
                    n7 = this.lastRenderBackgroundOffset;
                    n6 = n7 >> 16 & 0xFFFF;
                    n5 = (n7 &= 0xFFFF) + n6 * this.renderPixelWidth;
                    this.zBufferF[n5] = n2 | n3 << 16 & 0xFFFF0000;
                    this.lastRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                }
                n2 = n9;
            }
        }
        n3 = this.lastRenderBackgroundOffset;
        n2 = n3 >> 16 & 0xFFFF;
        n = (n3 &= 0xFFFF) + n2 * this.renderPixelWidth;
        this.zBufferF[n] = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
        this.lastRenderBackgroundOffset = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
    }

    private final CompiledMesh getFirstMeshToRender() {
        return this.firstMeshToRender;
    }

    private final CompiledMesh getNextMeshToRender(CompiledMesh compiledMesh) {
        return compiledMesh.nextMeshToRender;
    }

    private final void drawMesh3D(IScene3D iScene3D) {
        Serializable serializable;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        this.zBufferMode = 1;
        while (compiledMesh != null) {
            serializable = compiledMesh.mesh;
            if ((serializable.renderMode & 1) != 0) {
                this.prepareMesh3DLocalLight3DBuffer(iScene3D, (Mesh3D)serializable);
            }
            this.drawer.setMesh3D((Mesh3D)serializable);
            CompiledFace compiledFace = compiledMesh.firstFaceToRender;
            while (compiledFace != null) {
                this.drawer.drawFace3D(compiledMesh, compiledFace, false);
                compiledFace = compiledFace.nextFaceToRender;
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferMode = 2;
        serializable = this.firstAlphaFace;
        while (serializable != null) {
            this.setCurrentMesh3D(((Face3D)serializable).object);
            this.setFaces3DToZBuffer(((Face3D)serializable).object.faces3D, ((Face3D)serializable).id);
            serializable = ((Face3D)serializable).nextAlphaFace;
        }
    }

    public final String getImplementationName() {
        return "SOFT";
    }

    public final int getRenderedMesh3DIdAt(int n, int n2) {
        if ((this.antialias & 2) != 0) {
            n *= 2;
        }
        if ((this.antialias & 4) != 0) {
            n2 *= 2;
        }
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferO[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final int getRenderedFace3DIdAt(int n, int n2) {
        if ((this.antialias & 2) != 0) {
            n *= 2;
        }
        if ((this.antialias & 4) != 0) {
            n2 *= 2;
        }
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferP[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final double getZAt(int n, int n2) {
        int n3 = this.getRenderedMesh3DIdAt(n, n2);
        if (n3 == -1) {
            return this.zMax;
        }
        int n4 = this.getRenderedFace3DIdAt(n, n2);
        CompiledFace compiledFace = this.compiledMeshes[n3].compiledFaces[n4];
        double d = (double)n * compiledFace.iZA + (double)n2 * compiledFace.iZB + compiledFace.iZC;
        return 1.0 / d;
    }

    class CompiledMaterial {
        private static final int MAT_SIZE = 2048;
        Material material;
        int[] specularLightMap;

        CompiledMaterial(Material material) {
            this.material = material;
            this.specularLightMap = new int[2048];
            this.initSpecularLightMap();
        }

        public void initSpecularLightMap() {
            for (int i = 0; i < 2048; ++i) {
                int n = Math.min(i - 1024, 512);
                double d = 1.0 * (double)n / 512.0;
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                int n2 = (int)(d * 255.0);
                if ((n2 += this.material.selfIlluminationLevel * 255 / 100) > 255) {
                    n2 = 255;
                }
                if (this.material.specularLevel != 0) {
                    double d2 = (this.material.specularColor & 0xFF0000) >> 16;
                    double d3 = (this.material.specularColor & 0xFF00) >> 8;
                    double d4 = this.material.specularColor & 0xFF;
                    int n3 = (int)(Math.pow(d, this.material.specularPower) * (double)this.material.specularLevel);
                    int n4 = (int)(d2 *= (double)n3 / 256.0);
                    int n5 = (int)(d3 *= (double)n3 / 256.0);
                    int n6 = (int)(d4 *= (double)n3 / 256.0);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    this.specularLightMap[i] = n2 << 24 | (n4 << 16 | n5 << 8 | n6);
                    continue;
                }
                this.specularLightMap[i] = n2 << 24;
            }
        }
    }

    class CompiledMesh {
        Mesh3D mesh;
        CompiledMesh nextMeshToRender;
        int lastRenderImage;
        int nbRenderFace;
        int[] cameraPositionEvaluated;
        double[] xs;
        double[] ys;
        double[] iz;
        double[] xp;
        double[] yp;
        double[] zp;
        CompiledFace[] compiledFaces;
        CompiledFace firstFaceToRender;
        CompiledMesh3DOctree[] compiledMesh3DOctrees;

        CompiledMesh(Mesh3D mesh3D) {
            int n;
            this.mesh = mesh3D;
            this.nextMeshToRender = null;
            this.nbRenderFace = 0;
            this.lastRenderImage = -2;
            int n2 = mesh3D.getNbVertex3D();
            this.compiledFaces = new CompiledFace[mesh3D.getNbFace3D()];
            this.cameraPositionEvaluated = new int[n2];
            this.xs = new double[n2];
            this.ys = new double[n2];
            this.iz = new double[n2];
            this.xp = new double[n2];
            this.yp = new double[n2];
            this.zp = new double[n2];
            this.compiledMesh3DOctrees = null;
            for (n = 0; n < mesh3D.getNbFace3D(); ++n) {
                this.compiledFaces[n] = new CompiledFace((Face3D)mesh3D.getFace3D(n));
            }
            if (mesh3D.getMesh3DOctree() != null) {
                n = 1 + mesh3D.octree.getNbChildren(true);
                this.compiledMesh3DOctrees = new CompiledMesh3DOctree[n];
                IMesh3DOctree[] iMesh3DOctreeArray = mesh3D.octree.getMesh3DOctreeArray(new Mesh3DOctree[n]);
                for (int i = 0; i < n; ++i) {
                    this.compiledMesh3DOctrees[i] = new CompiledMesh3DOctree((Mesh3DOctree)iMesh3DOctreeArray[i]);
                }
            }
        }
    }

    class CompiledMesh3DOctree {
        int lastVisibleImage;
        Mesh3DOctree tree;

        CompiledMesh3DOctree(Mesh3DOctree mesh3DOctree) {
            this.tree = mesh3DOctree;
            this.lastVisibleImage = -2;
        }
    }

    class CompiledFace {
        Face3D face;
        CompiledFace nextFaceToRender;
        CompiledMaterial compiledMaterial;
        int lastRenderImage;
        int firstRenderOffset;
        int lastRenderOffset;
        int lastZbufferImage;
        float p0tx;
        float p0ty;
        float p0tz;
        float p1tx;
        float p1ty;
        float p1tz;
        float p2tx;
        float p2ty;
        float p2tz;
        float p0bx;
        float p0by;
        float p0bz;
        float p1bx;
        float p1by;
        float p1bz;
        float p2bx;
        float p2by;
        float p2bz;
        double iZA;
        double iZB;
        double iZC;
        double iD;
        double a;
        double b;
        double c;
        double zMin;
        double zMax;

        CompiledFace(Face3D face3D) {
            this.face = face3D;
            this.nextFaceToRender = null;
            this.lastRenderImage = -2;
            this.firstRenderOffset = -1;
            this.lastRenderOffset = -1;
            this.lastZbufferImage = -1;
            this.computeTBN();
            this.compiledMaterial = face3D.material != null ? Render3DSW.this.compiledMaterials[face3D.material.id] : Render3DSW.this.compiledMaterials[0];
        }

        public void computeScreenSpace() {
            Render3DSW render3DSW = Render3DSW.this;
            double d = this.face.p0.x;
            double d2 = this.face.p0.y;
            double d3 = this.face.p0.z;
            double d4 = (double)this.face.pa + d;
            double d5 = (double)this.face.pb + d2;
            double d6 = (double)this.face.pc + d3;
            double d7 = Render3DSW.this.ox + render3DSW.axx * d + render3DSW.ayx * d2 + render3DSW.azx * d3;
            double d8 = Render3DSW.this.oy + render3DSW.axy * d + render3DSW.ayy * d2 + render3DSW.azy * d3;
            double d9 = Render3DSW.this.oz + render3DSW.axz * d + render3DSW.ayz * d2 + render3DSW.azz * d3;
            double d10 = Render3DSW.this.ox + render3DSW.axx * d4 + render3DSW.ayx * d5 + render3DSW.azx * d6;
            double d11 = Render3DSW.this.oy + render3DSW.axy * d4 + render3DSW.ayy * d5 + render3DSW.azy * d6;
            double d12 = Render3DSW.this.oz + render3DSW.axz * d4 + render3DSW.ayz * d5 + render3DSW.azz * d6;
            this.a = d10 - d7;
            this.b = d11 - d8;
            this.c = d12 - d9;
            double d13 = -(this.a * d7 + this.b * d8 + this.c * d9);
            this.iD = 1.0 / d13;
            double d14 = this.iD * Render3DSW.this.iFocus;
            this.iZA = -this.a * d14;
            this.iZB = -this.b * d14;
            this.iZC = -this.c * this.iD;
        }

        void computeTBN() {
            double d = this.face.u1 - this.face.u0;
            double d2 = this.face.v1 - this.face.v0;
            double d3 = this.face.u2 - this.face.u0;
            double d4 = this.face.v2 - this.face.v0;
            Point3D point3D = new Point3D();
            point3D.copy(this.face.p1);
            point3D.sub(this.face.p0);
            point3D.mul(-d4);
            Point3D point3D2 = new Point3D();
            point3D2.copy(this.face.p2);
            point3D2.sub(this.face.p0);
            point3D2.mul(-d2);
            point3D.sub(point3D2);
            point3D.normalize();
            this.p0tx = (float)point3D.x;
            this.p0ty = (float)point3D.y;
            this.p0tz = (float)point3D.z;
            this.p1tx = (float)point3D.x;
            this.p1ty = (float)point3D.y;
            this.p1tz = (float)point3D.z;
            this.p2tx = (float)point3D.x;
            this.p2ty = (float)point3D.y;
            this.p2tz = (float)point3D.z;
            Point3D point3D3 = new Point3D();
            point3D3.copy(this.face.p1);
            point3D3.sub(this.face.p0);
            point3D3.mul(d3);
            Point3D point3D4 = new Point3D();
            point3D4.copy(this.face.p2);
            point3D4.sub(this.face.p0);
            point3D4.mul(d);
            point3D3.sub(point3D4);
            point3D3.normalize();
            this.p0bx = (float)point3D3.x;
            this.p0by = (float)point3D3.y;
            this.p0bz = (float)point3D3.z;
            this.p1bx = (float)point3D3.x;
            this.p1by = (float)point3D3.y;
            this.p1bz = (float)point3D3.z;
            this.p2bx = (float)point3D3.x;
            this.p2by = (float)point3D3.y;
            this.p2bz = (float)point3D3.z;
        }
    }
}

