/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation.value;

import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.DoubleValueFactory;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.FloatValueFactory;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.IntegerValueFactory;
import proguard.optimize.evaluation.value.LongValue;
import proguard.optimize.evaluation.value.LongValueFactory;

class SpecificFloatValue
extends FloatValue {
    private float value;

    public SpecificFloatValue(float f) {
        this.value = f;
    }

    public float value() {
        return this.value;
    }

    public FloatValue generalize(FloatValue floatValue) {
        return floatValue.generalize(this);
    }

    public FloatValue add(FloatValue floatValue) {
        return floatValue.add(this);
    }

    public FloatValue subtract(FloatValue floatValue) {
        return floatValue.subtractFrom(this);
    }

    public FloatValue subtractFrom(FloatValue floatValue) {
        return floatValue.subtract(this);
    }

    public FloatValue multiply(FloatValue floatValue) {
        return floatValue.multiply(this);
    }

    public FloatValue divide(FloatValue floatValue) {
        return floatValue.divideOf(this);
    }

    public FloatValue divideOf(FloatValue floatValue) {
        return floatValue.divide(this);
    }

    public FloatValue remainder(FloatValue floatValue) {
        return floatValue.remainderOf(this);
    }

    public FloatValue remainderOf(FloatValue floatValue) {
        return floatValue.remainder(this);
    }

    public IntegerValue compare(FloatValue floatValue) {
        return floatValue.compareReverse(this);
    }

    public FloatValue negate() {
        return FloatValueFactory.create(-this.value);
    }

    public IntegerValue convertToInteger() {
        return IntegerValueFactory.create((int)this.value);
    }

    public LongValue convertToLong() {
        return LongValueFactory.create((long)this.value);
    }

    public DoubleValue convertToDouble() {
        return DoubleValueFactory.create(this.value);
    }

    public FloatValue generalize(SpecificFloatValue specificFloatValue) {
        return this.value == specificFloatValue.value ? this : FloatValueFactory.create();
    }

    public FloatValue add(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(this.value + specificFloatValue.value);
    }

    public FloatValue subtract(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(this.value - specificFloatValue.value);
    }

    public FloatValue subtractFrom(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(specificFloatValue.value - this.value);
    }

    public FloatValue multiply(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(this.value * specificFloatValue.value);
    }

    public FloatValue divide(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(this.value / specificFloatValue.value);
    }

    public FloatValue divideOf(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(specificFloatValue.value / this.value);
    }

    public FloatValue remainder(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(this.value % specificFloatValue.value);
    }

    public FloatValue remainderOf(SpecificFloatValue specificFloatValue) {
        return FloatValueFactory.create(specificFloatValue.value % this.value);
    }

    public IntegerValue compare(SpecificFloatValue specificFloatValue) {
        return this.value < specificFloatValue.value ? IntegerValueFactory.create(-1) : (this.value == specificFloatValue.value ? IntegerValueFactory.create(0) : IntegerValueFactory.create(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificFloatValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "f:" + this.value;
    }
}

