/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.OutputWriter;
import proguard.classfile.ClassPool;
import proguard.classfile.editor.ConstantPoolSorter;
import proguard.classfile.visitor.ClassFilePrinter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.ProgramClassFileFilter;
import proguard.classfile.visitor.ProgramMemberInfoFilter;
import proguard.classfile.visitor.SimpleClassFilePrinter;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.shrink.Shrinker;

public class ProGuard {
    public static final String VERSION = "ProGuard, version 3.9";
    private Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private ClassPool libraryClassPool = new ClassPool();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        System.out.println(VERSION);
        GPL.check();
        this.readInput();
        if (this.configuration.defaultPackage != null) {
            this.configuration.allowAccessModification = true;
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.initialize();
        }
        if (this.configuration.printSeeds != null) {
            this.printSeeds();
        }
        if (this.configuration.shrink) {
            this.shrink();
        }
        if (this.configuration.optimize) {
            this.optimize();
            if (this.configuration.shrink) {
                this.configuration.printUsage = null;
                this.configuration.whyAreYouKeeping = null;
                this.shrink();
            }
        }
        if (this.configuration.obfuscate) {
            this.obfuscate();
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.sortConstantPools();
        }
        if (this.configuration.programJars.hasOutput()) {
            this.writeOutput();
        }
        if (this.configuration.dump != null) {
            this.dump();
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading input...");
        }
        new InputReader(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void initialize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Initializing...");
        }
        new Initializer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintStream printStream = this.isFile(this.configuration.printSeeds) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printSeeds))) : System.out;
        SimpleClassFilePrinter simpleClassFilePrinter = new SimpleClassFilePrinter(false, printStream);
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)new ProgramClassFileFilter(simpleClassFilePrinter), (MemberInfoVisitor)new ProgramMemberInfoFilter(simpleClassFilePrinter));
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        if (printStream != System.out) {
            printStream.close();
        }
    }

    private void shrink() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
            if (this.configuration.whyAreYouKeeping != null) {
                System.out.println("Explaining why classes and class members are being kept...");
            }
            if (this.configuration.printUsage != null) {
                System.out.println("Printing usage" + (this.isFile(this.configuration.printUsage) ? " to [" + this.configuration.printUsage.getAbsolutePath() + "]" : "..."));
            }
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        int n = this.programClassPool.size();
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool);
        int n2 = this.programClassPool.size();
        if (n2 == 0) {
            throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
        }
        if (this.configuration.verbose) {
            System.out.println("Removing unused program classes and class elements...");
            System.out.println("  Original number of program classes: " + n);
            System.out.println("  Final number of program classes:    " + n2);
        }
    }

    private void optimize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Optimizing...");
        }
        if (this.configuration.keep == null && this.configuration.keepNames == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void obfuscate() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
            if (this.configuration.applyMapping != null) {
                System.out.println("Applying mapping [" + this.configuration.applyMapping.getAbsolutePath() + "]");
            }
            if (this.configuration.printMapping != null) {
                System.out.println("Printing mapping" + (this.isFile(this.configuration.printMapping) ? " to [" + this.configuration.printMapping.getAbsolutePath() + "]" : "..."));
            }
        }
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void sortConstantPools() {
        this.programClassPool.classFilesAccept(new ConstantPoolSorter(1024));
    }

    private void writeOutput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Writing output...");
        }
        new OutputWriter(this.configuration).execute(this.programClassPool);
    }

    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes" + (this.isFile(this.configuration.dump) ? " to [" + this.configuration.dump.getAbsolutePath() + "]" : "..."));
        }
        PrintStream printStream = this.isFile(this.configuration.dump) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.dump))) : System.out;
        this.programClassPool.classFilesAccept(new ClassFilePrinter(printStream));
        if (this.isFile(this.configuration.dump)) {
            printStream.close();
        }
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(VERSION);
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray);
            try {
                configurationParser.parse(configuration);
                new ProGuard(configuration).execute();
            }
            finally {
                configurationParser.close();
            }
        }
        catch (Exception exception) {
            if (configuration.verbose) {
                exception.printStackTrace();
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

