/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.MappingUV;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.PixelsBufferBI;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render2D;
import net.dzzd.core.Render3D;
import net.dzzd.core.Render3DSW;
import net.dzzd.core.Texture;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

class Drawer {
    public int[] debug = new int[40000];
    public int nbDebug = 0;
    static int[] iZ;
    static int[] log2;
    static int[] normalMap;
    private boolean useMIS;
    private MemoryImageSource imageMemoire;
    private Image image;
    private int[] pixels;
    private int[] rPixels;
    private int[] zBuffer;
    private int[] zBufferF;
    private int[] softBuffer;
    private int[] softBufferR;
    private int renderPixelWidth;
    private int renderPixelHeight;
    private double renderPixelWidthDiv2;
    private double renderPixelHeightDiv2;
    private double iFocus;
    private double iZoomX;
    private double iZoomY;
    private double zoomX;
    private double zoomY;
    private int antialias;
    private int nbSoftPoint;
    private int lastSoftPoint;
    private int renderMode;
    private int faceRenderMode;
    private double textureLevel;
    private Render3D.Mesh3DLight3D[] mesh3DLocalLight3DBuffer;
    private Mesh3D objRef;
    private Face3D polRef;
    private Material material;
    private MappingUV mapping;
    Render3DSW.CompiledMesh compiledMesh;
    Render3DSW.CompiledFace compiledFace;
    Render3DSW.CompiledMaterial compiledMaterial;
    private double ox;
    private double oy;
    private double oz;
    private double axx;
    private double axy;
    private double axz;
    private double ayx;
    private double ayy;
    private double ayz;
    private double azx;
    private double azy;
    private double azz;
    private int XBF;
    private int YBF;
    private int startXYBF;
    private int endXYBF;
    private double iZA;
    private double iZB;
    private double iZC;
    private double iUBA;
    private double iUBB;
    private double iUBC;
    private double iVBA;
    private double iVBB;
    private double iVBC;
    private double iWBA;
    private double iWBB;
    private double iWBC;
    private double incUBDivZ;
    private double incVBDivZ;
    private double incWBDivZ;
    private double iUA;
    private double iUB;
    private double iUC;
    private double iVA;
    private double iVB;
    private double iVC;
    private double incUDivZ;
    private double incVDivZ;
    private double dpDivZ;
    private int[] specularLightMap;
    private int[] dTexturePixels;
    private int dDecalLargeur;
    private int dDecalHauteur;
    private int dMaskHauteur;
    private int dMaskLargeur;
    private int dLargeurImage;
    private int dHauteurImage;
    private int dNbMipMap;
    private int[][] dMipMap;
    private int[] bTexturePixels;
    private int bDecalLargeur;
    private int bDecalHauteur;
    private int bMaskHauteur;
    private int bMaskLargeur;
    private int bLargeurImage;
    private int bHauteurImage;
    private int bNbMipMap;
    private int[][] bMipMap;
    private int[] eTexturePixels;
    private int eDecalLargeur;
    private int eDecalHauteur;
    private int eMaskHauteur;
    private int eMaskLargeur;
    private int eLargeurImage;
    private int eHauteurImage;
    private int eNbMipMap;
    private int[][] eMipMap;
    private double currentTextureLevel;
    private int fogColor;
    private int startXY;
    private int endXY;
    private int iZi;
    private int incIzi;
    private int scaleZ;
    private int[] normalPixels;
    private int[] envPixels;
    private int numMipMap;
    private int[] texturePixels;
    private int decalLargeur;
    private int decalHauteur;
    private int maskHauteur;
    private int maskLargeur;
    private int largeurImage;
    private int hauteurImage;
    private int endXMipMap;
    private int maskUV;
    private int decUBX;
    private int decVBX;
    private int uDivZi;
    private int incUDivZi;
    private int vDivZi;
    private int incVDivZi;
    private int scaleU;
    private int scaleV;
    private int decU;
    private int decV;
    private int uDiv2;
    private int vDiv2;
    private int UBDivZi;
    private int incUBDivZi;
    private int VBDivZi;
    private int incVBDivZi;
    private int WBDivZi;
    private int incWBDivZi;
    private int lastColor;
    private int co1 = 0;
    private int co2 = 0;
    private int co3 = 0;
    private int co4 = 0;
    private int no1 = 0;
    private int no2 = 0;
    private int no3 = 0;
    private int no4 = 0;
    private int envColor = 0;
    private int alphaLevel = 0;
    private int normal = 0;
    private int pixelColor = 0;
    private int u = 0;
    private int v = 0;
    private int rZ;
    private int rDiffuseTexel;
    private int rNormalTexel;
    private int rEnvironmentTexel;
    private int rDiffuseLight;
    private int rSpecularColor;
    int f24;
    int f23;
    int f14;
    int f13;
    boolean useDiffuseTexture;
    boolean useNormalTexture;
    boolean useEnvironmentTexure;

    Drawer() {
    }

    public final void setBuffers(Render3DSW render3DSW, int[] nArray, int[] nArray2) {
        this.antialias = render3DSW.antialias;
        this.renderPixelWidth = render3DSW.getWidth();
        this.renderPixelHeight = render3DSW.getHeight();
        if ((this.antialias & 2) != 0) {
            this.renderPixelWidth <<= 1;
        }
        if ((this.antialias & 4) != 0) {
            this.renderPixelHeight <<= 1;
        }
        this.renderPixelWidthDiv2 = this.renderPixelWidth >> 1;
        this.renderPixelHeightDiv2 = this.renderPixelHeight >> 1;
        this.initPixelsBuffer(render3DSW.viewPixelWidth, render3DSW.viewPixelHeight);
        this.rPixels = this.antialias > 1 ? new int[this.renderPixelWidth * this.renderPixelHeight] : this.pixels;
        this.zBuffer = nArray;
        this.zBufferF = nArray2;
        this.softBuffer = new int[this.renderPixelWidth * this.renderPixelHeight >> 2];
        this.softBufferR = new int[this.renderPixelWidth * this.renderPixelHeight >> 2];
    }

    public final void setRender3DSW(Render3DSW render3DSW) {
        this.renderMode = render3DSW.render3DMode;
        this.iFocus = render3DSW.iFocus;
        this.iZoomX = render3DSW.iZoomX;
        this.iZoomY = render3DSW.iZoomY;
        this.zoomX = 1.0 / this.iZoomX;
        this.zoomY = 1.0 / this.iZoomY;
        this.textureLevel = 3.0;
        this.mesh3DLocalLight3DBuffer = render3DSW.mesh3DLocalLight3DBuffer;
        this.nbSoftPoint = 0;
    }

    public final void drawBackground(int n, int n2, int n3) {
        this.setStartSegment(n);
        this.setEndSegment(n2);
        n3 |= 0xFF000000;
        do {
            int n4 = (this.renderPixelHeight - this.YBF - 1) * this.renderPixelWidth;
            int n5 = this.YBF * this.renderPixelWidth;
            int n6 = this.XBF;
            int n7 = n4 + n6;
            int n8 = n5 + n6;
            int n9 = this.zBuffer[n8];
            int n10 = n9 >> 16 & 0xFF;
            double d = ((double)this.YBF - this.renderPixelHeightDiv2) * this.iZoomY;
            int n11 = n4 + (n9 &= 0xFFFF);
            while (n7 < n11) {
                this.rPixels[n7++] = n3;
            }
            if (this.XBF <= 0 || (this.antialias & 1) == 0) continue;
            this.softBuffer[this.nbSoftPoint] = n4 + this.XBF;
            this.softBufferR[this.nbSoftPoint++] = n10;
        } while (this.nextSegment());
    }

    private final void setStartSegment(int n) {
        this.XBF = n;
        this.YBF = this.XBF >> 16 & 0xFFFF;
        this.XBF &= 0xFFFF;
        this.startXYBF = this.XBF + this.YBF * this.renderPixelWidth;
    }

    private final boolean nextSegment() {
        this.XBF = this.zBufferF[this.startXYBF];
        this.YBF = this.XBF >> 16 & 0xFFFF;
        this.XBF &= 0xFFFF;
        this.startXYBF = this.XBF + this.YBF * this.renderPixelWidth;
        return this.startXYBF != this.endXYBF;
    }

    private final void setEndSegment(int n) {
        int n2 = n;
        int n3 = n2 >> 16 & 0xFFFF;
        int n4 = (n3 *= this.renderPixelWidth) + (n2 &= 0xFFFF);
        n2 = this.zBufferF[n4];
        n3 = n2 >> 16 & 0xFFFF;
        this.endXYBF = (n3 *= this.renderPixelWidth) + (n2 &= 0xFFFF);
    }

    public final void setMesh3D(Mesh3D mesh3D) {
        this.objRef = mesh3D;
        Axis3D axis3D = mesh3D.axes;
        Point3D point3D = axis3D.axeX;
        Point3D point3D2 = axis3D.axeY;
        Point3D point3D3 = axis3D.axeZ;
        Point3D point3D4 = axis3D.origine;
        this.ox = point3D4.x;
        this.oy = point3D4.y;
        this.oz = point3D4.z;
        this.axx = point3D.x - this.ox;
        this.axy = point3D.y - this.oy;
        this.axz = point3D.z - this.oz;
        this.ayx = point3D2.x - this.ox;
        this.ayy = point3D2.y - this.oy;
        this.ayz = point3D2.z - this.oz;
        this.azx = point3D3.x - this.ox;
        this.azy = point3D3.y - this.oy;
        this.azz = point3D3.z - this.oz;
    }

    public final void drawFace3D(Render3DSW.CompiledMesh compiledMesh, Render3DSW.CompiledFace compiledFace, boolean bl) {
        double d;
        double d2;
        double d3;
        this.compiledMesh = compiledMesh;
        this.compiledFace = compiledFace;
        this.compiledMaterial = compiledFace.compiledMaterial;
        this.polRef = this.compiledFace.face;
        this.material = this.polRef.material;
        this.mapping = this.material != null ? this.material.mapping : null;
        this.setStartSegment(this.compiledFace.firstRenderOffset);
        this.setEndSegment(this.compiledFace.lastRenderOffset);
        int n = 0;
        if (this.material != null) {
            this.rDiffuseTexel = this.material.diffuseColor;
            this.alphaLevel = this.material.alphaLevel;
            this.specularLightMap = this.compiledMaterial.specularLightMap;
            if (this.specularLightMap != null) {
                n |= 3;
                if (this.material.diffuseTexture != null && this.material.diffuseTexture.pixels != null) {
                    n |= 0x1C;
                    if (this.material.diffuseTextureDetail != null && this.material.diffuseTextureDetail.pixels != null) {
                        n |= 0x20;
                    }
                }
                if (this.material.bumpNormalTexture != null && this.material.bumpNormalTexture.pixels != null) {
                    n |= 0x98;
                }
                if (this.material.envTexture != null && this.material.envTexture.pixels != null) {
                    n |= 0x118;
                }
            }
        }
        n &= this.renderMode;
        this.faceRenderMode = n &= this.objRef.renderMode;
        this.currentTextureLevel = 0.0;
        if ((this.faceRenderMode & 8) != 0) {
            this.currentTextureLevel = this.textureLevel;
        }
        Vertex3D vertex3D = this.polRef.p0;
        Vertex3D vertex3D2 = this.polRef.p1;
        Vertex3D vertex3D3 = this.polRef.p2;
        double[] dArray = compiledMesh.xp;
        double[] dArray2 = compiledMesh.yp;
        double[] dArray3 = compiledMesh.zp;
        int n2 = vertex3D.id;
        int n3 = vertex3D2.id;
        int n4 = vertex3D3.id;
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        double d6 = dArray3[n2];
        double d7 = dArray[n3];
        double d8 = dArray2[n3];
        double d9 = dArray3[n3];
        double d10 = dArray[n4];
        double d11 = dArray2[n4];
        double d12 = dArray3[n4];
        double d13 = this.polRef.p0nx;
        double d14 = this.polRef.p0ny;
        double d15 = this.polRef.p0nz;
        double d16 = this.polRef.p1nx;
        double d17 = this.polRef.p1ny;
        double d18 = this.polRef.p1nz;
        double d19 = this.polRef.p2nx;
        double d20 = this.polRef.p2ny;
        double d21 = this.polRef.p2nz;
        double d22 = 1.0 / (d5 * (d10 - d7) + d8 * (d4 - d10) + d11 * (d7 - d4));
        double d23 = (double)this.polRef.pa + vertex3D.x;
        double d24 = (double)this.polRef.pb + vertex3D.y;
        double d25 = (double)this.polRef.pc + vertex3D.z;
        double d26 = this.compiledFace.iD;
        double d27 = this.compiledFace.a * d26;
        double d28 = this.compiledFace.b * d26;
        double d29 = this.compiledFace.c * d26;
        this.iZA = this.compiledFace.iZA;
        this.iZB = this.compiledFace.iZB;
        this.iZC = this.compiledFace.iZC;
        if (d13 * (double)this.polRef.pa + d14 * (double)this.polRef.pb + d15 * (double)this.polRef.pc > 0.99 && d16 * (double)this.polRef.pa + d17 * (double)this.polRef.pb + d18 * (double)this.polRef.pc > 0.99 && d19 * (double)this.polRef.pa + d20 * (double)this.polRef.pb + d21 * (double)this.polRef.pc > 0.99) {
            this.faceRenderMode |= 0x40;
        }
        double d30 = this.mesh3DLocalLight3DBuffer[0].axx;
        double d31 = this.mesh3DLocalLight3DBuffer[0].axy;
        double d32 = this.mesh3DLocalLight3DBuffer[0].axz;
        double d33 = this.mesh3DLocalLight3DBuffer[0].ayx;
        double d34 = this.mesh3DLocalLight3DBuffer[0].ayy;
        double d35 = this.mesh3DLocalLight3DBuffer[0].ayz;
        double d36 = this.mesh3DLocalLight3DBuffer[0].azx;
        double d37 = this.mesh3DLocalLight3DBuffer[0].azy;
        double d38 = this.mesh3DLocalLight3DBuffer[0].azz;
        double d39 = 0.0;
        double d40 = 0.0;
        double d41 = 0.0;
        double d42 = 0.0;
        double d43 = 0.0;
        double d44 = 0.0;
        double d45 = 1.0;
        double d46 = 1.0;
        double d47 = 1.0;
        if ((this.faceRenderMode & 0x80) == 0) {
            d39 = d30 * d13 + d31 * d14 + d32 * d15;
            d40 = d30 * d16 + d31 * d17 + d32 * d18;
            d41 = d30 * d19 + d31 * d20 + d32 * d21;
            d42 = d33 * d13 + d34 * d14 + d35 * d15;
            d43 = d33 * d16 + d34 * d17 + d35 * d18;
            d44 = d33 * d19 + d34 * d20 + d35 * d21;
            d45 = d36 * d13 + d37 * d14 + d38 * d15;
            d46 = d36 * d16 + d37 * d17 + d38 * d18;
            d47 = d36 * d19 + d37 * d20 + d38 * d21;
        } else {
            d3 = this.compiledFace.p0tx;
            d2 = this.compiledFace.p0ty;
            d = this.compiledFace.p0tz;
            double d48 = this.compiledFace.p1tx;
            double d49 = this.compiledFace.p1ty;
            double d50 = this.compiledFace.p1tz;
            double d51 = this.compiledFace.p2tx;
            double d52 = this.compiledFace.p2ty;
            double d53 = this.compiledFace.p2tz;
            double d54 = this.compiledFace.p0bx;
            double d55 = this.compiledFace.p0by;
            double d56 = this.compiledFace.p0bz;
            double d57 = this.compiledFace.p1bx;
            double d58 = this.compiledFace.p1by;
            double d59 = this.compiledFace.p1bz;
            double d60 = this.compiledFace.p2bx;
            double d61 = this.compiledFace.p2by;
            double d62 = this.compiledFace.p2bz;
            d39 = d36 * d3 + d37 * d2 + d38 * d;
            d42 = d36 * d54 + d37 * d55 + d38 * d56;
            d45 = d36 * d13 + d37 * d14 + d38 * d15;
            d40 = d36 * d48 + d37 * d49 + d38 * d50;
            d43 = d36 * d57 + d37 * d58 + d38 * d59;
            d46 = d36 * d16 + d37 * d17 + d38 * d18;
            d41 = d36 * d51 + d37 * d52 + d38 * d53;
            d44 = d36 * d60 + d37 * d61 + d38 * d62;
            d47 = d36 * d19 + d37 * d20 + d38 * d21;
        }
        d3 = 0.5 - 0.3 * d39;
        d2 = 0.5 - 0.3 * d40;
        d = 0.5 - 0.3 * d41;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.iUBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iUBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iUBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iUBA -= this.iUBC * d27;
        this.iUBB -= this.iUBC * d28;
        this.iUBC = -this.iUBC * d29;
        this.iUBA *= this.iFocus;
        this.iUBB *= this.iFocus;
        d3 = 0.5 - 0.3 * d42;
        d2 = 0.5 - 0.3 * d43;
        d = 0.5 - 0.3 * d44;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.iVBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iVBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iVBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iVBA -= this.iVBC * d27;
        this.iVBB -= this.iVBC * d28;
        this.iVBC = -this.iVBC * d29;
        this.iVBA *= this.iFocus;
        this.iVBB *= this.iFocus;
        d3 = 0.5 - 0.3 * d45;
        d2 = 0.5 - 0.3 * d46;
        d = 0.5 - 0.3 * d47;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.iWBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iWBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iWBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iWBA -= this.iWBC * d27;
        this.iWBB -= this.iWBC * d28;
        this.iWBC = -this.iWBC * d29;
        this.iWBA *= this.iFocus;
        this.iWBB *= this.iFocus;
        this.incUBDivZ = this.iUBA * this.iZoomX;
        this.incVBDivZ = this.iVBA * this.iZoomX;
        this.incWBDivZ = this.iWBA * this.iZoomX;
        Texture texture = null;
        if (this.material != null) {
            this.eTexturePixels = null;
            if (this.material.envTexture != null && this.material.envTexture.pixels != null) {
                texture = this.material.envTexture;
                this.eTexturePixels = texture.pixels;
                this.eDecalLargeur = texture.decalLargeur;
                this.eDecalHauteur = texture.decalHauteur;
                this.eMaskHauteur = texture.maskHauteur;
                this.eMaskLargeur = texture.maskLargeur;
                this.eLargeurImage = texture.largeurImage;
                this.eHauteurImage = texture.hauteurImage;
                this.eNbMipMap = texture.nbMipMap;
                this.eMipMap = texture.mipMap;
            }
            this.bTexturePixels = null;
            if (this.material.bumpNormalTexture != null && this.material.bumpNormalTexture.pixels != null) {
                texture = this.material.bumpNormalTexture;
                this.bTexturePixels = texture.pixels;
                this.bDecalLargeur = texture.decalLargeur;
                this.bDecalHauteur = texture.decalHauteur;
                this.bMaskHauteur = texture.maskHauteur;
                this.bMaskLargeur = texture.maskLargeur;
                this.bLargeurImage = texture.largeurImage;
                this.bHauteurImage = texture.hauteurImage;
                this.bNbMipMap = texture.nbMipMap;
                this.bMipMap = texture.mipMap;
            }
            this.dTexturePixels = null;
            if (this.material.diffuseTexture != null && this.material.diffuseTexture.pixels != null) {
                texture = this.material.diffuseTexture;
                this.dTexturePixels = texture.pixels;
                this.dDecalLargeur = texture.decalLargeur;
                this.dDecalHauteur = texture.decalHauteur;
                this.dMaskHauteur = texture.maskHauteur;
                this.dMaskLargeur = texture.maskLargeur;
                this.dLargeurImage = texture.largeurImage;
                this.dHauteurImage = texture.hauteurImage;
                this.dNbMipMap = texture.nbMipMap;
                this.dMipMap = texture.mipMap;
            }
            if (this.dTexturePixels != null || this.bTexturePixels != null) {
                double d63 = this.polRef.u0 * this.mapping.zoomU + this.mapping.ofsU;
                double d64 = this.polRef.u1 * this.mapping.zoomU + this.mapping.ofsU;
                double d65 = this.polRef.u2 * this.mapping.zoomU + this.mapping.ofsU;
                double d66 = this.polRef.v0 * this.mapping.zoomV + this.mapping.ofsV;
                double d67 = this.polRef.v1 * this.mapping.zoomV + this.mapping.ofsV;
                double d68 = this.polRef.v2 * this.mapping.zoomV + this.mapping.ofsV;
                this.iUA = (d5 * (d65 - d64) + d8 * (d63 - d65) + d11 * (d64 - d63)) * d22;
                this.iUB = (-d4 * (d65 - d64) - d7 * (d63 - d65) - d10 * (d64 - d63)) * d22;
                this.iUC = (d5 * (d64 * d10 - d65 * d7) + d8 * (d65 * d4 - d63 * d10) + d11 * (d63 * d7 - d64 * d4)) * d22;
                this.iUA -= this.iUC * d27;
                this.iUB -= this.iUC * d28;
                this.iUC = -this.iUC * d29;
                this.iUA *= this.iFocus;
                this.iUB *= this.iFocus;
                this.iVA = (d5 * (d68 - d67) + d8 * (d66 - d68) + d11 * (d67 - d66)) * d22;
                this.iVB = (-d4 * (d68 - d67) - d7 * (d66 - d68) - d10 * (d67 - d66)) * d22;
                this.iVC = (d5 * (d67 * d10 - d68 * d7) + d8 * (d68 * d4 - d66 * d10) + d11 * (d66 * d7 - d67 * d4)) * d22;
                this.iVA -= this.iVC * d27;
                this.iVB -= this.iVC * d28;
                this.iVC = -this.iVC * d29;
                this.iVA *= this.iFocus;
                this.iVB *= this.iFocus;
                double d69 = 1.0;
                double d70 = -this.iZA / this.iZB;
                double d71 = d69 * this.zoomX;
                double d72 = d70 * this.zoomY;
                if (d71 < 0.0) {
                    d71 = -d71;
                }
                if (d72 < 0.0) {
                    d72 = -d72;
                }
                double d73 = d69 * this.iUA + d70 * this.iUB;
                double d74 = d69 * this.iVA + d70 * this.iVB;
                if (d73 < 0.0) {
                    d73 = -d73;
                }
                if (d74 < 0.0) {
                    d74 = -d74;
                }
                this.currentTextureLevel += this.compiledFace.c * 2.0;
                this.dpDivZ = this.currentTextureLevel * ((d73 *= (double)texture.largeurImage) + (d74 *= (double)texture.hauteurImage)) / (d71 + d72);
                this.incUDivZ = this.iUA * this.iZoomX;
                this.incVDivZ = this.iVA * this.iZoomX;
            }
        }
        this.drawFace3DPixels();
    }

    private final void drawFace3DPixels() {
        do {
            int n = (this.renderPixelHeight - this.YBF - 1) * this.renderPixelWidth;
            int n2 = this.YBF * this.renderPixelWidth;
            int n3 = this.XBF;
            this.startXY = n + n3;
            int n4 = n2 + n3;
            int n5 = this.zBuffer[n4];
            int n6 = n5 >> 16 & 0xFF;
            n5 &= 0xFFFF;
            double d = ((double)this.YBF - this.renderPixelHeightDiv2) * this.iZoomY;
            double d2 = d * this.iZB + this.iZC;
            double d3 = d2 - this.renderPixelWidthDiv2 * this.iZA * this.iZoomX;
            double d4 = this.iZA * this.iZoomX;
            double d5 = d * this.iUBB + this.iUBC;
            double d6 = d * this.iVBB + this.iVBC;
            double d7 = d * this.iWBB + this.iWBC;
            double d8 = d * this.iUB + this.iUC;
            double d9 = d * this.iVB + this.iVC;
            while (n3 < n5) {
                double d10;
                double d11;
                int n7 = n5;
                int n8 = n3;
                double d12 = n7 - n8;
                double d13 = (double)n8 - this.renderPixelWidthDiv2;
                double d14 = (double)n7 - this.renderPixelWidthDiv2;
                d14 *= this.iZoomX;
                double d15 = (d13 *= this.iZoomX) * this.iZA + d2;
                double d16 = d15 + d12 * d4;
                double d17 = 1.0 / d15;
                double d18 = 1.0 / d16;
                double d19 = d15;
                double d20 = d16;
                double d21 = d17;
                double d22 = d18;
                if (d17 > d18) {
                    d11 = d17;
                    d17 = d18;
                    d18 = d11;
                }
                if (d17 != d18 && d12 > 8.0 && d17 * 4.0 < d18) {
                    if (d4 > 0.0) {
                        d17 = 0.25 * d21;
                        d22 = 0.25 * d21;
                        d20 = 4.0 * d19;
                    } else {
                        d18 = 4.0 * d21;
                        d22 = 4.0 * d21;
                        d20 = 0.25 * d19;
                    }
                    int n9 = n8 + (int)((d20 - d19) / d4);
                    if (n9 - n7 > 8) {
                        if (n9 > n7) {
                            n9 = n7;
                        }
                        n7 = n9;
                    } else {
                        n7 = n8 + 8;
                    }
                    d12 = n7 - n8;
                    d20 = d19 + d4 * d12;
                    d22 = 1.0 / d20;
                }
                d11 = 1.0 / d12;
                if (d12 == 1.0) {
                    // empty if block
                }
                n3 = n7;
                int n10 = n + n7;
                double d23 = 0.1 * d18;
                double d24 = 2.147483647E9 * d23;
                this.iZi = (int)(d15 * d24);
                this.incIzi = (int)(d4 * d24);
                this.scaleZ = (int)d23;
                if ((this.faceRenderMode & 1) != 0) {
                    d10 = 2.147483647E9 * d23;
                    this.incUBDivZi = (int)(this.incUBDivZ * d10);
                    this.incVBDivZi = (int)(this.incVBDivZ * d10);
                    this.incWBDivZi = (int)(this.incWBDivZ * d10);
                    this.UBDivZi = (int)((d13 * this.iUBA + d5) * d10);
                    this.VBDivZi = (int)((d13 * this.iVBA + d6) * d10);
                    this.WBDivZi = (int)((d13 * this.iWBA + d7) * d10);
                }
                if ((this.faceRenderMode & 4) != 0 || (this.faceRenderMode & 0x80) != 0) {
                    d10 = d13 * this.iUA + d8;
                    double d25 = d13 * this.iVA + d9;
                    double d26 = d10 * d21;
                    double d27 = (d10 + this.incUDivZ * d12) * d22;
                    d27 -= (double)((int)d26);
                    d26 -= (double)((int)d26);
                    d10 = d26 * d19;
                    double d28 = d27 * d20;
                    double d29 = (d28 - d10) * d11;
                    this.scaleU = (int)(d27 - d26);
                    if (this.scaleU < 0) {
                        this.scaleU = -this.scaleU;
                    }
                    if (this.scaleU == 0) {
                        this.scaleU = 1;
                    }
                    double d30 = d25 * d21;
                    double d31 = (d25 + this.incVDivZ * d12) * d22;
                    d31 -= (double)((int)d30);
                    d30 -= (double)((int)d30);
                    d25 = d30 * d19;
                    double d32 = d31 * d20;
                    double d33 = (d32 - d25) * d11;
                    this.scaleV = (int)(d31 - d30);
                    if (this.scaleV < 0) {
                        this.scaleV = -this.scaleV;
                    }
                    if (this.scaleV == 0) {
                        this.scaleV = 1;
                    }
                    double d34 = d24 / (double)this.scaleU;
                    double d35 = d24 / (double)this.scaleV;
                    this.uDivZi = (int)(d10 * d34);
                    this.vDivZi = (int)(d25 * d35);
                    this.incUDivZi = (int)(d29 * d34);
                    this.incVDivZi = (int)(d33 * d35);
                    double d36 = this.dpDivZ * d21;
                    this.numMipMap = 0;
                    int n11 = (int)d36;
                    if (n11 >= 0) {
                        this.numMipMap = n11 < log2.length ? log2[n11] : 32;
                    }
                }
                while (this.startXY < n10) {
                    int n12;
                    this.endXY = n10;
                    if ((this.faceRenderMode & 4) != 0 || (this.faceRenderMode & 0x80) != 0) {
                        if (this.numMipMap < 0) {
                            this.numMipMap = 0;
                        }
                        if ((this.faceRenderMode & 0x80) != 0) {
                            this.normalPixels = this.bTexturePixels;
                            this.decalLargeur = this.bDecalLargeur;
                            this.decalHauteur = this.bDecalHauteur;
                            this.maskHauteur = this.bMaskHauteur;
                            this.maskLargeur = this.bMaskLargeur;
                            this.largeurImage = this.bLargeurImage;
                            this.hauteurImage = this.bHauteurImage;
                        }
                        if ((this.faceRenderMode & 4) != 0) {
                            this.texturePixels = this.dTexturePixels;
                            this.decalLargeur = this.dDecalLargeur;
                            this.decalHauteur = this.dDecalHauteur;
                            this.maskHauteur = this.dMaskHauteur;
                            this.maskLargeur = this.dMaskLargeur;
                            this.largeurImage = this.dLargeurImage;
                            this.hauteurImage = this.dHauteurImage;
                        }
                        this.endXMipMap = n7;
                        if (this.numMipMap >= 1) {
                            if (this.numMipMap > this.dNbMipMap) {
                                this.numMipMap = this.dNbMipMap;
                            }
                            if (this.dNbMipMap > 0 && this.dMipMap[this.numMipMap - 1] != null) {
                                this.texturePixels = this.dMipMap[this.numMipMap - 1];
                                this.decalLargeur -= this.numMipMap;
                                this.decalHauteur -= this.numMipMap;
                                this.maskLargeur >>= this.numMipMap;
                                this.maskHauteur >>= this.numMipMap;
                                this.largeurImage >>= this.numMipMap;
                                this.hauteurImage >>= this.numMipMap;
                                if (this.normalPixels != null) {
                                    this.normalPixels = this.bMipMap[this.numMipMap - 1];
                                }
                            }
                        }
                        int n13 = this.numMipMap;
                        if (this.numMipMap >= this.dNbMipMap) {
                            this.numMipMap = this.dNbMipMap;
                        }
                        if (d4 != 0.0) {
                            n13 = d15 < d16 ? this.numMipMap : this.numMipMap + 1;
                            double d37 = 1 << n13;
                            double d38 = this.dpDivZ / d37;
                            double d39 = (d38 - d3) / d4;
                            this.endXMipMap = (int)d39 + 1;
                        } else {
                            this.endXMipMap = n7;
                        }
                        this.numMipMap = d15 < d16 ? --this.numMipMap : ++this.numMipMap;
                        this.decU = 32 - this.decalLargeur;
                        this.decV = 32 - this.decalHauteur;
                        this.maskHauteur <<= this.decalLargeur;
                        this.decV -= this.decalLargeur;
                        this.maskUV = this.maskHauteur | this.maskLargeur;
                        this.decUBX = this.decU - 8;
                        this.decVBX = this.decV + this.decalLargeur - 8;
                        this.uDiv2 = 1 << this.decU - 1;
                        this.vDiv2 = 1 << this.decV - 1;
                        n12 = n + this.endXMipMap;
                        if (n12 <= this.startXY) {
                            n12 = n10;
                        }
                        if (n12 > n10) {
                            n12 = n10;
                        }
                        if (this.maskLargeur == 0) {
                            this.startXY = n12;
                        }
                        this.endXY = n12;
                    }
                    int n14 = iZ[(this.iZi & 0x7FFF8000) >> 15];
                    n12 = iZ[(this.iZi + this.incIzi * (this.endXY - this.startXY) & 0x7FFF8000) >> 15];
                    this.drawPixelsFull();
                }
            }
            if (this.XBF <= 0 || (this.antialias & 1) == 0) continue;
            this.softBuffer[this.nbSoftPoint] = n + this.XBF;
            this.softBufferR[this.nbSoftPoint++] = n6;
        } while (this.nextSegment());
    }

    private final int bilinUV(int n, int n2, int n3, int n4) {
        int n5 = ((n & 0xFF00FF) * this.f13 + (n2 & 0xFF00FF) * this.f23 + (n3 & 0xFF00FF) * this.f14 + (n4 & 0xFF00FF) * this.f24 & 0xFF00FF00 | (n & 0xFF00) * this.f13 + (n2 & 0xFF00) * this.f23 + (n3 & 0xFF00) * this.f14 + (n4 & 0xFF00) * this.f24 & 0xFF0000) >> 8;
        return n5;
    }

    private final void computeTexture() {
        int n = (this.uDivZi >> 12) * this.rZ * this.scaleU - this.uDiv2;
        int n2 = (this.vDivZi >> 12) * this.rZ * this.scaleV - this.vDiv2;
        this.uDivZi += this.incUDivZi;
        this.vDivZi += this.incVDivZi;
        this.u = n >> this.decU & this.maskLargeur;
        this.v = n2 >> this.decV & this.maskHauteur;
        int n3 = this.v | this.u;
        int n4 = n3 + 1 & this.maskUV;
        int n5 = n3 + this.largeurImage & this.maskUV;
        int n6 = n5 + 1 & this.maskUV;
        int n7 = n >> this.decUBX & 0xFF;
        int n8 = n2 >> this.decVBX & 0xFF;
        this.f24 = n7 * n8 >> 8;
        this.f23 = n7 - this.f24;
        this.f14 = n8 - this.f24;
        this.f13 = (n7 ^ 0xFF) * (n8 ^ 0xFF) >> 8;
        if (this.useNormalTexture) {
            this.rNormalTexel = this.bilinUV(this.normalPixels[n3], this.normalPixels[n4], this.normalPixels[n5], this.normalPixels[n6]);
        }
        if (this.useDiffuseTexture) {
            this.pixelColor = this.rDiffuseTexel = this.bilinUV(this.texturePixels[n3], this.texturePixels[n4], this.texturePixels[n5], this.texturePixels[n6]);
        }
    }

    private final void computeFastTexture() {
        int n = (this.uDivZi >> 12) * this.rZ * this.scaleU - this.uDiv2;
        int n2 = (this.vDivZi >> 12) * this.rZ * this.scaleV - this.vDiv2;
        this.uDivZi += this.incUDivZi << 1;
        this.vDivZi += this.incVDivZi << 1;
        this.u = n >> this.decU & this.maskLargeur;
        this.v = n2 >> this.decV & this.maskHauteur;
        int n3 = this.v | this.u;
        int n4 = n3 + 1 & this.maskUV;
        int n5 = n3 + this.largeurImage & this.maskUV;
        int n6 = n5 + 1 & this.maskUV;
        int n7 = n >> this.decUBX & 0xFF;
        int n8 = n2 >> this.decVBX & 0xFF;
        this.f24 = n7 * n8 >> 8;
        this.f23 = n7 - this.f24;
        this.f14 = n8 - this.f24;
        this.f13 = (n7 ^ 0xFF) * (n8 ^ 0xFF) >> 8;
        if (this.useNormalTexture) {
            this.rNormalTexel = this.bilinUV(this.normalPixels[n3], this.normalPixels[n4], this.normalPixels[n5], this.normalPixels[n6]);
        }
        if (this.useDiffuseTexture) {
            this.pixelColor = this.rDiffuseTexel = this.bilinUV(this.texturePixels[n3], this.texturePixels[n4], this.texturePixels[n5], this.texturePixels[n6]);
        }
    }

    private final void computeLight() {
        int n;
        int n2;
        int n3;
        int n4 = ((this.WBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        int n5 = ((this.UBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        int n6 = ((this.VBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        this.UBDivZi += this.incUBDivZi;
        this.VBDivZi += this.incVBDivZi;
        this.WBDivZi += this.incWBDivZi;
        int n7 = normalMap[n5 * n5 + n6 * n6 + n4 * n4 & 0xFFFF] >> 6;
        if (this.useNormalTexture) {
            n3 = ((this.rNormalTexel & 0xFF0000) >> 16) - 128;
            n2 = ((this.rNormalTexel & 0xFF00) >> 8) - 128;
            n = (this.rNormalTexel & 0xFF) - 128;
            n7 = (n3 * n5 + n2 * n6 + n * n4) * (n7 >> 8) >> 15;
            n7 += 1024;
        } else {
            n7 = n4 * n7 >> 16;
            n7 += 1024;
        }
        n3 = this.specularLightMap[n7];
        this.rSpecularColor = n3 & 0xFFFFFF;
        this.rDiffuseLight = n3 >>> 24;
        if (this.useEnvironmentTexure) {
            n2 = n5 * n7 >> 9;
            n = n6 * n7 >> 9;
            this.rSpecularColor = this.eTexturePixels[((n += 128) & this.eMaskHauteur) << this.eDecalLargeur | (n2 += 128) & this.eMaskLargeur];
        }
    }

    private final void computeFastLight() {
        int n;
        int n2;
        int n3;
        int n4 = ((this.WBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        int n5 = ((this.UBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        int n6 = ((this.VBDivZi >> 13) * this.rZ >> 23 & 0xFF) - 128;
        this.UBDivZi += this.incUBDivZi << 1;
        this.VBDivZi += this.incVBDivZi << 1;
        this.WBDivZi += this.incWBDivZi << 1;
        int n7 = normalMap[n5 * n5 + n6 * n6 + n4 * n4 & 0xFFFF] >> 15;
        if (this.useNormalTexture) {
            n3 = ((this.rNormalTexel & 0xFF0000) >> 16) - 128;
            n2 = ((this.rNormalTexel & 0xFF00) >> 8) - 128;
            n = (this.rNormalTexel & 0xFF) - 128;
            n7 = (n3 * n5 + n2 * n6 + n * n4) * n7 >> 15;
            n7 += 512;
        } else {
            n7 = n4 * n7 >> 8;
            n7 += 512;
        }
        n3 = this.specularLightMap[n7];
        this.rSpecularColor = n3 & 0xFFFFFF;
        this.rDiffuseLight = n3 >> 24 & 0xFF;
        if (this.useEnvironmentTexure) {
            n2 = n5 * n7 >> 9;
            n = n6 * n7 >> 9;
            this.rSpecularColor = 0xFEFEFE & this.eTexturePixels[((n += 128) & this.eMaskHauteur) << this.eDecalLargeur | (n2 += 128) & this.eMaskLargeur];
        }
    }

    private final void drawPixelsFull() {
        this.rDiffuseLight = 255;
        this.rSpecularColor = 0;
        this.pixelColor = this.rDiffuseTexel;
        try {
            this.useEnvironmentTexure = (this.faceRenderMode & 0x100) != 0;
            this.useDiffuseTexture = (this.faceRenderMode & 4) != 0;
            this.useNormalTexture = (this.faceRenderMode & 0x80) != 0;
            boolean bl = this.useDiffuseTexture || this.useNormalTexture;
            boolean bl2 = (this.faceRenderMode & 1) != 0;
            boolean bl3 = this.alphaLevel != 0;
            boolean bl4 = false;
            if (bl) {
                if (bl2) {
                    while (this.startXY < this.endXY) {
                        this.rZ = iZ[this.iZi >>> 16];
                        this.iZi += this.incIzi;
                        this.computeTexture();
                        this.computeLight();
                        int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                        this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                        this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                        this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                    }
                } else {
                    while (this.startXY < this.endXY) {
                        this.rZ = iZ[this.iZi >>> 16];
                        this.iZi += this.incIzi;
                        this.computeTexture();
                        int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                        this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                        this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                        this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                    }
                }
            } else if (bl2) {
                while (this.startXY < this.endXY) {
                    this.rZ = iZ[this.iZi >>> 16];
                    this.iZi += this.incIzi;
                    this.computeLight();
                    int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                    this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                    this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                    this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                }
            } else {
                while (this.startXY < this.endXY) {
                    this.rZ = iZ[this.iZi >>> 16];
                    this.iZi += this.incIzi;
                    int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                    this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                    this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                    this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.log(arrayIndexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            Log.log(nullPointerException);
        }
        this.startXY = this.endXY;
    }

    public final void antialiasPixels() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < this.nbDebug; ++n6) {
            this.pixels[this.debug[n6]] = 0x880000;
        }
        this.nbDebug = 0;
        if ((this.antialias & 1) != 0) {
            for (n6 = 0; n6 < this.nbSoftPoint; ++n6) {
                n5 = this.softBuffer[n6];
                n4 = this.rPixels[n5 - 1];
                n3 = this.rPixels[n5];
                n2 = this.softBufferR[n6];
                n4 = ((n4 & 0xFF00FF) * n2 & 0xFF00FF00 | (n4 & 0xFF00) * n2 & 0xFF0000) >> 8;
                n2 = 255 - n2;
                n3 = ((n3 & 0xFF00FF) * n2 & 0xFF00FF00 | (n3 & 0xFF00) * n2 & 0xFF0000) >> 8;
                this.softBufferR[n6] = n = (n4 & 0xFEFEFE) + (n3 & 0xFEFEFE);
            }
            for (n6 = 0; n6 < this.nbSoftPoint; ++n6) {
                n5 = this.softBuffer[n6];
                this.rPixels[n5] = this.softBufferR[n6];
            }
        }
        if (this.antialias > 1) {
            n6 = this.antialias & 0xFE;
            switch (n6) {
                case 2: {
                    for (n5 = 0; n5 < this.renderPixelHeight; ++n5) {
                        n2 = n4 + (this.renderPixelWidth >> 1);
                        n = n4 << 1;
                        for (n3 = n4 = n5 * (this.renderPixelWidth >> 1); n3 < n2; ++n3) {
                            int n7 = this.rPixels[n] & 0xFEFEFE;
                            int n8 = this.rPixels[n + 1] & 0xFEFEFE;
                            this.pixels[n3] = n7 + n8 >> 1;
                            n += 2;
                        }
                    }
                    break;
                }
                case 4: {
                    for (n5 = 0; n5 < this.renderPixelHeight >> 1; ++n5) {
                        n2 = n4 + this.renderPixelWidth;
                        n = n4 << 1;
                        for (n3 = n4 = n5 * this.renderPixelWidth; n3 < n2; ++n3) {
                            int n9;
                            int n10 = this.rPixels[n] & 0xFEFEFE;
                            int n11 = this.rPixels[n + this.renderPixelWidth] & 0xFEFEFE;
                            this.pixels[n3] = n9 = n10 + n11 >> 1;
                            ++n;
                        }
                    }
                    break;
                }
                case 6: {
                    for (n5 = 0; n5 < this.renderPixelHeight >> 1; ++n5) {
                        n2 = n4 + (this.renderPixelWidth >> 1);
                        n = n4 << 2;
                        for (n3 = n4 = n5 * (this.renderPixelWidth >> 1); n3 < n2; ++n3) {
                            int n12 = this.rPixels[n];
                            int n13 = this.rPixels[n + 1];
                            int n14 = this.rPixels[n + this.renderPixelWidth];
                            int n15 = this.rPixels[n + this.renderPixelWidth + 1];
                            int n16 = (n12 & 0xFF00FF) + (n13 & 0xFF00FF) + (n14 & 0xFF00FF) + (n15 & 0xFF00FF) >> 2 & 0xFF00FF;
                            int n17 = (n12 & 0xFF00) + (n13 & 0xFF00) + (n14 & 0xFF00) + (n15 & 0xFF00) >> 2 & 0xFF00;
                            this.pixels[n3] = n16 | n17;
                            n += 2;
                        }
                    }
                    break;
                }
            }
        }
    }

    private final void initPixelsBuffer(int n, int n2) {
        Object object;
        this.useMIS = true;
        try {
            object = Class.forName("java.awt.image.BufferedImage");
            PixelsBufferBI pixelsBufferBI = new PixelsBufferBI(n, n2);
            this.image = pixelsBufferBI.getImage();
            this.pixels = pixelsBufferBI.getPixels();
            this.useMIS = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.useMIS) {
            this.pixels = new int[n * n2];
            object = new DirectColorModel(24, 0xFF0000, 65280, 255);
            this.imageMemoire = new MemoryImageSource(n, n2, (ColorModel)object, this.pixels, 0, n);
            this.imageMemoire.setAnimated(true);
            this.imageMemoire.setFullBufferUpdates(false);
            this.image = Toolkit.getDefaultToolkit().createImage(this.imageMemoire);
            this.useMIS = true;
        }
    }

    public final void drawPixelsOnCanvas(Canvas canvas) {
        Graphics graphics = canvas.getGraphics();
        if (this.useMIS) {
            this.imageMemoire.newPixels();
        }
        if (graphics != null) {
            ((Render2D.PCanvas)canvas).image = this.image;
            canvas.update(graphics);
        }
    }

    static {
        int n;
        iZ = new int[65536];
        log2 = new int[2048];
        normalMap = new int[65536];
        for (n = 0; n < log2.length; ++n) {
            Drawer.log2[n] = (int)(Math.log(n) / 0.6931471805599453);
        }
        for (n = 1; n < iZ.length; ++n) {
            Drawer.iZ[n] = (int)(2.147483647E9 / (double)n) >> 3;
        }
        Drawer.normalMap[0] = 1;
        for (n = 1; n < normalMap.length; ++n) {
            Drawer.normalMap[n] = (int)(2.147483647E9 / Math.sqrt(n));
        }
    }
}

