/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.DzzD;
import net.dzzd.access.IAxis3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.IFace3DList;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3D;
import net.dzzd.access.ISolidSphere3D;
import net.dzzd.access.ISolidSphere3DResult;
import net.dzzd.core.Point3D;
import net.dzzd.core.Scene3DObject;
import net.dzzd.core.SolidSphere3DResult;
import net.dzzd.core.collision.SphereToEdgeImpact;
import net.dzzd.utils.Log;

public final class SolidSphere3D
extends Scene3DObject
implements ISolidSphere3D {
    private IScene3D scene;
    private double radius = 1.0;
    private SolidSphere3DResult result;
    private IPoint3D source;
    private SolidSphere3DResult meshResult;
    private IPoint3D destination;
    private SphereToEdgeImpact sie1;
    private SphereToEdgeImpact sie2;
    private SphereToEdgeImpact sie3;
    String name;
    private double sx;
    private double sy;
    private double sz;
    private double dx;
    private double dy;
    private double dz;
    private double moveWorldX;
    private double moveWorldY;
    private double moveWorldZ;
    private double moveNorme;
    private double moveINorme;
    IPoint3D d1 = DzzD.newPoint3D();
    IPoint3D d2 = DzzD.newPoint3D();
    private IPoint3D p = DzzD.newPoint3D();
    private IPoint3D v0 = DzzD.newPoint3D();
    private IPoint3D v1 = DzzD.newPoint3D();
    private IPoint3D v2 = DzzD.newPoint3D();

    public SolidSphere3D() {
        this.source = new Point3D();
        this.destination = new Point3D();
        this.result = new SolidSphere3DResult();
        this.meshResult = new SolidSphere3DResult();
        this.sie1 = new SphereToEdgeImpact();
        this.sie2 = new SphereToEdgeImpact();
        this.sie3 = new SphereToEdgeImpact();
    }

    public final void setScene3D(IScene3D iScene3D) {
        this.scene = iScene3D;
    }

    public final void setRadius(double d) {
        this.radius = d;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final ISolidSphere3DResult getResult() {
        return this.meshResult;
    }

    public final void setSource(double d, double d2, double d3) {
        this.source.set(d, d2, d3);
    }

    public final void setDestination(double d, double d2, double d3) {
        this.destination.set(d, d2, d3);
    }

    public final void setSource(IPoint3D iPoint3D) {
        this.source = iPoint3D;
    }

    public final void setDestination(IPoint3D iPoint3D) {
        this.destination = iPoint3D;
    }

    public final IPoint3D getSource() {
        return this.source;
    }

    public final IPoint3D getDestination() {
        return this.destination;
    }

    public final void moveSlide(double d, double d2, double d3, int n) {
        this.destination.set(d, d2, d3);
        this.destination.add(this.source);
        this.moveSlide(n);
    }

    public final ISolidSphere3DResult move() {
        return this.moveSlide(1);
    }

    public final ISolidSphere3DResult moveSlide(int n) {
        return this.moveBounce(n, 0.0);
    }

    public final ISolidSphere3DResult moveBounce(int n, double d) {
        for (int i = 0; i < n; ++i) {
            this.sphereToWorldImpact(d);
            if (!this.meshResult.hit) {
                this.source.copy(this.destination);
                return this.meshResult;
            }
            if (Double.isNaN(this.meshResult.displace.getX())) {
                Log.log("errorx");
            }
            if (Double.isNaN(this.meshResult.displace.getY())) {
                Log.log("errory");
            }
            if (Double.isNaN(this.meshResult.displace.getZ())) {
                Log.log("errorz");
            }
            this.source.add(this.meshResult.displace);
            this.destination.copy(this.source).add(this.meshResult.newDisplace);
        }
        return this.meshResult;
    }

    private final void sphereToWorldImpact(double d) {
        IPoint3D iPoint3D = this.source;
        IPoint3D iPoint3D2 = this.destination;
        this.sx = iPoint3D.getX();
        this.sy = iPoint3D.getY();
        this.sz = iPoint3D.getZ();
        this.dx = iPoint3D2.getX();
        this.dy = iPoint3D2.getY();
        this.dz = iPoint3D2.getZ();
        this.moveWorldX = this.dx - this.sx;
        this.moveWorldY = this.dy - this.sy;
        this.moveWorldZ = this.dz - this.sz;
        this.moveNorme = Math.sqrt(this.moveWorldX * this.moveWorldX + this.moveWorldY * this.moveWorldY + this.moveWorldZ * this.moveWorldZ);
        this.moveINorme = 1.0 / this.moveNorme;
        this.meshResult.resetImpact();
        this.meshResult.impactDistance = this.moveNorme * this.moveNorme;
        if (this.moveNorme == 0.0) {
            return;
        }
        int n = this.scene.getNbMesh3D();
        for (int i = 0; i < n; ++i) {
            this.sphereToMeshImpact(this.scene.getMesh3DById(i), d);
        }
    }

    private final void sphereToMeshImpact(IMesh3D iMesh3D, double d) {
        if (!iMesh3D.isSolid()) {
            return;
        }
        this.result.resetImpact();
        this.result.impactDistance = this.moveNorme * this.moveNorme;
        IAxis3D iAxis3D = iMesh3D.getAxis3D();
        IPoint3D iPoint3D = iAxis3D.getAX();
        IPoint3D iPoint3D2 = iAxis3D.getAY();
        IPoint3D iPoint3D3 = iAxis3D.getAZ();
        IPoint3D iPoint3D4 = iAxis3D.getOrigin();
        double d2 = iPoint3D4.getX();
        double d3 = iPoint3D4.getY();
        double d4 = iPoint3D4.getZ();
        double d5 = iPoint3D.getX() - d2;
        double d6 = iPoint3D.getY() - d3;
        double d7 = iPoint3D.getZ() - d4;
        double d8 = iPoint3D2.getX() - d2;
        double d9 = iPoint3D2.getY() - d3;
        double d10 = iPoint3D2.getZ() - d4;
        double d11 = iPoint3D3.getX() - d2;
        double d12 = iPoint3D3.getY() - d3;
        double d13 = iPoint3D3.getZ() - d4;
        double d14 = this.sx - d2;
        double d15 = this.sy - d3;
        double d16 = this.sz - d4;
        double d17 = d5 * d14 + d6 * d15 + d7 * d16;
        double d18 = d8 * d14 + d9 * d15 + d10 * d16;
        double d19 = d11 * d14 + d12 * d15 + d13 * d16;
        double d20 = this.radius + this.moveNorme + iMesh3D.getSphereBox();
        IPoint3D iPoint3D5 = iMesh3D.getCenter();
        double d21 = iPoint3D5.getX() - d17;
        double d22 = iPoint3D5.getY() - d18;
        double d23 = iPoint3D5.getZ() - d19;
        if (d21 * d21 + d22 * d22 + d23 * d23 > d20 * d20) {
            return;
        }
        d14 = this.dx - d2;
        d15 = this.dy - d3;
        d16 = this.dz - d4;
        double d24 = d5 * d14 + d6 * d15 + d7 * d16;
        double d25 = d8 * d14 + d9 * d15 + d10 * d16;
        double d26 = d11 * d14 + d12 * d15 + d13 * d16;
        boolean bl = false;
        if (iMesh3D.getMesh3DCollisionGenerator() != null) {
            iMesh3D.getMesh3DCollisionGenerator().generateForSolidSphere3DCollision(d17, d18, d19, d24, d25, d26, this.radius);
            IFace3DList iFace3DList = iMesh3D.getMesh3DCollisionGenerator().getCollisionFace3DList();
            bl = this.sphereToFacesImpact(iFace3DList, this.radius, d17, d18, d19, d24, d25, d26);
        } else {
            bl = this.sphereToFacesImpact(iMesh3D.getFaces3D(), this.radius, d17, d18, d19, d24, d25, d26);
        }
        if (bl && this.result.impactDistance < this.meshResult.impactDistance) {
            d14 = this.result.sphereP.getX();
            d15 = this.result.sphereP.getY();
            d16 = this.result.sphereP.getZ();
            double d27 = d2 + d5 * d14 + d8 * d15 + d11 * d16;
            double d28 = d3 + d6 * d14 + d9 * d15 + d12 * d16;
            double d29 = d4 + d7 * d14 + d10 * d15 + d13 * d16;
            d14 = this.result.planeP.getX();
            d15 = this.result.planeP.getY();
            d16 = this.result.planeP.getZ();
            double d30 = d2 + d5 * d14 + d8 * d15 + d11 * d16;
            double d31 = d3 + d6 * d14 + d9 * d15 + d12 * d16;
            double d32 = d4 + d7 * d14 + d10 * d15 + d13 * d16;
            d14 = this.result.slidePlane.getX();
            d15 = this.result.slidePlane.getY();
            d16 = this.result.slidePlane.getZ();
            double d33 = d5 * d14 + d8 * d15 + d11 * d16;
            double d34 = d6 * d14 + d9 * d15 + d12 * d16;
            double d35 = d7 * d14 + d10 * d15 + d13 * d16;
            this.result.sphereP.set(d27, d28, d29);
            this.result.planeP.set(d30, d31, d32);
            this.result.slidePlane.set(d33, d34, d35);
            this.result.displace.copy(this.result.planeP).sub(this.result.sphereP);
            this.result.slidePlaneOffset = -this.result.planeP.dot(this.result.slidePlane);
            double d36 = this.destination.dot(this.result.slidePlane) + this.result.slidePlaneOffset;
            this.result.newDisplace.copy(this.result.slidePlane).mul(this.radius * 1.001 - d36).mul(1.0 + d).add(this.destination);
            this.result.newDisplace.sub(this.source).sub(this.result.displace);
            this.meshResult.copy(this.result);
            this.meshResult.meshId = iMesh3D.getId();
        }
    }

    private final boolean sphereToFaceImpact(IFace3D iFace3D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        boolean bl = false;
        double d17 = this.radius + this.moveNorme + iFace3D.getSphereBox();
        IPoint3D iPoint3D = iFace3D.getCenter();
        double d18 = iPoint3D.getX() - d2;
        if (d18 * d18 + (d16 = iPoint3D.getY() - d3) * d16 + (d15 = iPoint3D.getZ() - d4) * d15 > d17 * d17) {
            return false;
        }
        double d19 = iFace3D.getPA();
        double d20 = iFace3D.getPB();
        double d21 = iFace3D.getPC();
        double d22 = iFace3D.getPD();
        double d23 = d2 - d19 * d;
        double d24 = d3 - d20 * d;
        double d25 = d4 - d21 * d;
        double d26 = d23 + d5;
        double d27 = d24 + d6;
        double d28 = d25 + d7;
        double d29 = d19 * d2 + d20 * d3 + d21 * d4 + d22;
        double d30 = d19 * d23 + d20 * d24 + d21 * d25 + d22;
        double d31 = d19 * d26 + d20 * d27 + d21 * d28 + d22;
        double d32 = d19 * d8 + d20 * d9 + d21 * d10;
        if (d32 >= 0.0) {
            return false;
        }
        if (d31 > 0.0) {
            return false;
        }
        if (d30 <= -this.radius) {
            return false;
        }
        if (d30 > 0.0) {
            d14 = d30 / (d30 - d31);
            d13 = d23 + d14 * d5;
            d12 = d24 + d14 * d6;
            d11 = d25 + d14 * d7;
        } else {
            d13 = d23 - d30 * d19;
            d12 = d24 - d30 * d20;
            d11 = d25 - d30 * d21;
        }
        this.p.set(d13, d12, d11);
        if (this.pointInTriangle(this.p, iFace3D.getVertex3D0(), iFace3D.getVertex3D1(), iFace3D.getVertex3D2())) {
            this.d1.set(d13, d12, d11);
            this.d2.set(d23, d24, d25);
            d14 = this.d1.sub(this.d2).length2();
            if (d30 < 0.0) {
                d14 = d30;
            }
            if (d14 <= this.result.impactDistance) {
                this.result.impactDistance = d14;
                this.result.sphereP.set(d23, d24, d25);
                this.result.planeP.set(d13, d12, d11);
                this.result.slidePlane.set(d19, d20, d21);
                this.result.faceId = iFace3D.getId();
                bl = true;
                this.result.hit = true;
                return bl;
            }
            return bl;
        }
        SphereToEdgeImpact sphereToEdgeImpact = null;
        this.sie1.doImpact(d2, d3, d4, d, d5, d6, d7, iFace3D.getVertex3D0().getX(), iFace3D.getVertex3D0().getY(), iFace3D.getVertex3D0().getZ(), iFace3D.getVertex3D1().getX(), iFace3D.getVertex3D1().getY(), iFace3D.getVertex3D1().getZ());
        this.sie2.doImpact(d2, d3, d4, d, d5, d6, d7, iFace3D.getVertex3D1().getX(), iFace3D.getVertex3D1().getY(), iFace3D.getVertex3D1().getZ(), iFace3D.getVertex3D2().getX(), iFace3D.getVertex3D2().getY(), iFace3D.getVertex3D2().getZ());
        this.sie3.doImpact(d2, d3, d4, d, d5, d6, d7, iFace3D.getVertex3D2().getX(), iFace3D.getVertex3D2().getY(), iFace3D.getVertex3D2().getZ(), iFace3D.getVertex3D0().getX(), iFace3D.getVertex3D0().getY(), iFace3D.getVertex3D0().getZ());
        if (this.sie1.hit) {
            sphereToEdgeImpact = this.sie1;
        }
        if (this.sie2.hit && (sphereToEdgeImpact == null || this.sie2.hitTime < sphereToEdgeImpact.hitTime)) {
            sphereToEdgeImpact = this.sie2;
        }
        if (this.sie3.hit && (sphereToEdgeImpact == null || this.sie3.hitTime < sphereToEdgeImpact.hitTime)) {
            sphereToEdgeImpact = this.sie3;
        }
        if (sphereToEdgeImpact != null && sphereToEdgeImpact.hit && sphereToEdgeImpact.hitTime <= 1.0) {
            double d33 = sphereToEdgeImpact.hitSphereX - sphereToEdgeImpact.hitX;
            double d34 = sphereToEdgeImpact.hitSphereY - sphereToEdgeImpact.hitY;
            double d35 = sphereToEdgeImpact.hitSphereZ - sphereToEdgeImpact.hitZ;
            double d36 = Math.sqrt(d33 * d33 + d34 * d34 + d35 * d35);
            double d37 = 1.0 / d36;
            if (d33 * d8 + d34 * d9 + d35 * d10 >= 0.0) {
                return false;
            }
            d23 = d2 - d33 * d * d37;
            d24 = d3 - d34 * d * d37;
            d25 = d4 - d35 * d * d37;
            d13 = sphereToEdgeImpact.hitX;
            d12 = sphereToEdgeImpact.hitY;
            d11 = sphereToEdgeImpact.hitZ;
            this.d1.set(d13, d12, d11);
            this.d2.set(d23, d24, d25);
            double d38 = this.d1.sub(this.d2).length2();
            if (sphereToEdgeImpact.hitTime == 0.0) {
                d38 = -d38;
            }
            if (d38 <= this.result.impactDistance) {
                this.result.impactDistance = d38;
                this.result.sphereP.set(d23, d24, d25);
                this.result.planeP.set(d13, d12, d11);
                this.result.slidePlane.set(d33 * d37, d34 * d37, d35 * d37);
                this.result.faceId = iFace3D.getId();
                bl = true;
                this.result.hit = true;
            }
        }
        return bl;
    }

    private final boolean sphereToFacesImpact(IFace3DList iFace3DList, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl = false;
        boolean bl2 = false;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        double d10 = d7 - d4;
        double d11 = d8 * this.moveINorme;
        double d12 = d9 * this.moveINorme;
        double d13 = d10 * this.moveINorme;
        for (IFace3DList iFace3DList2 = iFace3DList; iFace3DList2 != null; iFace3DList2 = iFace3DList2.getNextFace3DList()) {
            if (!this.sphereToFaceImpact(iFace3DList2.getFace3D(), this.radius, d2, d3, d4, d8, d9, d10, d11, d12, d13)) continue;
            bl = true;
        }
        return bl;
    }

    private final boolean sphereToFacesImpact(IFace3D[] iFace3DArray, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl = false;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        double d10 = d7 - d4;
        double d11 = d8 * this.moveINorme;
        double d12 = d9 * this.moveINorme;
        double d13 = d10 * this.moveINorme;
        int n = iFace3DArray.length;
        for (int i = 0; i < n; ++i) {
            IFace3D iFace3D = iFace3DArray[i];
            if (!this.sphereToFaceImpact(iFace3D, this.radius, d2, d3, d4, d8, d9, d10, d11, d12, d13)) continue;
            bl = true;
        }
        return bl;
    }

    private final boolean pointInTriangle(IPoint3D iPoint3D, IPoint3D iPoint3D2, IPoint3D iPoint3D3, IPoint3D iPoint3D4) {
        this.v0.copy(iPoint3D4);
        this.v1.copy(iPoint3D3);
        this.v2.copy(iPoint3D);
        this.v0.sub(iPoint3D2);
        this.v1.sub(iPoint3D2);
        this.v2.sub(iPoint3D2);
        double d = this.v0.dot(this.v0);
        double d2 = this.v0.dot(this.v1);
        double d3 = this.v0.dot(this.v2);
        double d4 = this.v1.dot(this.v1);
        double d5 = this.v1.dot(this.v2);
        double d6 = 1.0 / (d * d4 - d2 * d2);
        double d7 = (d4 * d3 - d2 * d5) * d6;
        double d8 = (d * d5 - d2 * d3) * d6;
        return d7 > 0.0 && d8 > 0.0 && d7 + d8 < 1.0;
    }
}

